/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.ThreadpoolFlexible;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.threadpool.flexible.ThreadFactory;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadpoolFlexibleBuilder {
    private Long _keepAliveMillis;
    private static List<Range<BigInteger>> _keepAliveMillis_range;
    private Integer _maxThreadCount;
    private static List<Range<BigInteger>> _maxThreadCount_range;
    private Integer _minThreadCount;
    private static List<Range<BigInteger>> _minThreadCount_range;
    private Integer _queueCapacity;
    private static List<Range<BigInteger>> _queueCapacity_range;
    private ThreadFactory _threadFactory;
    Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>();

    public ThreadpoolFlexibleBuilder() {
    }

    public ThreadpoolFlexibleBuilder(ThreadpoolFlexible base) {
        this._keepAliveMillis = base.getKeepAliveMillis();
        this._maxThreadCount = base.getMaxThreadCount();
        this._minThreadCount = base.getMinThreadCount();
        this._queueCapacity = base.getQueueCapacity();
        this._threadFactory = base.getThreadFactory();
        if (base instanceof ThreadpoolFlexibleImpl) {
            ThreadpoolFlexibleImpl _impl = (ThreadpoolFlexibleImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(_impl.augmentation);
        }
    }

    public Long getKeepAliveMillis() {
        return this._keepAliveMillis;
    }

    public Integer getMaxThreadCount() {
        return this._maxThreadCount;
    }

    public Integer getMinThreadCount() {
        return this._minThreadCount;
    }

    public Integer getQueueCapacity() {
        return this._queueCapacity;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ThreadpoolFlexibleBuilder setKeepAliveMillis(Long value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : ThreadpoolFlexibleBuilder._keepAliveMillis_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _keepAliveMillis_range));
            }
        }
        this._keepAliveMillis = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _keepAliveMillis_range() {
        if (_keepAliveMillis_range != null) return _keepAliveMillis_range;
        Class<ThreadpoolFlexibleBuilder> clazz = ThreadpoolFlexibleBuilder.class;
        synchronized (ThreadpoolFlexibleBuilder.class) {
            if (_keepAliveMillis_range != null) return _keepAliveMillis_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _keepAliveMillis_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _keepAliveMillis_range;
        }
    }

    public ThreadpoolFlexibleBuilder setMaxThreadCount(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : ThreadpoolFlexibleBuilder._maxThreadCount_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _maxThreadCount_range));
            }
        }
        this._maxThreadCount = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _maxThreadCount_range() {
        if (_maxThreadCount_range != null) return _maxThreadCount_range;
        Class<ThreadpoolFlexibleBuilder> clazz = ThreadpoolFlexibleBuilder.class;
        synchronized (ThreadpoolFlexibleBuilder.class) {
            if (_maxThreadCount_range != null) return _maxThreadCount_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _maxThreadCount_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _maxThreadCount_range;
        }
    }

    public ThreadpoolFlexibleBuilder setMinThreadCount(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : ThreadpoolFlexibleBuilder._minThreadCount_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _minThreadCount_range));
            }
        }
        this._minThreadCount = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _minThreadCount_range() {
        if (_minThreadCount_range != null) return _minThreadCount_range;
        Class<ThreadpoolFlexibleBuilder> clazz = ThreadpoolFlexibleBuilder.class;
        synchronized (ThreadpoolFlexibleBuilder.class) {
            if (_minThreadCount_range != null) return _minThreadCount_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _minThreadCount_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _minThreadCount_range;
        }
    }

    public ThreadpoolFlexibleBuilder setQueueCapacity(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : ThreadpoolFlexibleBuilder._queueCapacity_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _queueCapacity_range));
            }
        }
        this._queueCapacity = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _queueCapacity_range() {
        if (_queueCapacity_range != null) return _queueCapacity_range;
        Class<ThreadpoolFlexibleBuilder> clazz = ThreadpoolFlexibleBuilder.class;
        synchronized (ThreadpoolFlexibleBuilder.class) {
            if (_queueCapacity_range != null) return _queueCapacity_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _queueCapacity_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _queueCapacity_range;
        }
    }

    public ThreadpoolFlexibleBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public ThreadpoolFlexibleBuilder addAugmentation(Class<? extends Augmentation<ThreadpoolFlexible>> augmentationType, Augmentation<ThreadpoolFlexible> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadpoolFlexible build() {
        return new ThreadpoolFlexibleImpl(this);
    }

    private static final class ThreadpoolFlexibleImpl
    implements ThreadpoolFlexible {
        private final Long _keepAliveMillis;
        private final Integer _maxThreadCount;
        private final Integer _minThreadCount;
        private final Integer _queueCapacity;
        private final ThreadFactory _threadFactory;
        private Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>();

        public Class<ThreadpoolFlexible> getImplementedInterface() {
            return ThreadpoolFlexible.class;
        }

        private ThreadpoolFlexibleImpl(ThreadpoolFlexibleBuilder base) {
            this._keepAliveMillis = base.getKeepAliveMillis();
            this._maxThreadCount = base.getMaxThreadCount();
            this._minThreadCount = base.getMinThreadCount();
            this._queueCapacity = base.getQueueCapacity();
            this._threadFactory = base.getThreadFactory();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getKeepAliveMillis() {
            return this._keepAliveMillis;
        }

        @Override
        public Integer getMaxThreadCount() {
            return this._maxThreadCount;
        }

        @Override
        public Integer getMinThreadCount() {
            return this._minThreadCount;
        }

        @Override
        public Integer getQueueCapacity() {
            return this._queueCapacity;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._keepAliveMillis == null ? 0 : this._keepAliveMillis.hashCode());
            result = 31 * result + (this._maxThreadCount == null ? 0 : this._maxThreadCount.hashCode());
            result = 31 * result + (this._minThreadCount == null ? 0 : this._minThreadCount.hashCode());
            result = 31 * result + (this._queueCapacity == null ? 0 : this._queueCapacity.hashCode());
            result = 31 * result + (this._threadFactory == null ? 0 : this._threadFactory.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadpoolFlexible.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadpoolFlexible other = (ThreadpoolFlexible)obj;
            if (this._keepAliveMillis == null ? other.getKeepAliveMillis() != null : !this._keepAliveMillis.equals(other.getKeepAliveMillis())) {
                return false;
            }
            if (this._maxThreadCount == null ? other.getMaxThreadCount() != null : !this._maxThreadCount.equals(other.getMaxThreadCount())) {
                return false;
            }
            if (this._minThreadCount == null ? other.getMinThreadCount() != null : !this._minThreadCount.equals(other.getMinThreadCount())) {
                return false;
            }
            if (this._queueCapacity == null ? other.getQueueCapacity() != null : !this._queueCapacity.equals(other.getQueueCapacity())) {
                return false;
            }
            if (this._threadFactory == null ? other.getThreadFactory() != null : !this._threadFactory.equals(other.getThreadFactory())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadpoolFlexibleImpl otherImpl = (ThreadpoolFlexibleImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ThreadpoolFlexible [");
            boolean first = true;
            if (this._keepAliveMillis != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveMillis=");
                builder.append(this._keepAliveMillis);
            }
            if (this._maxThreadCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxThreadCount=");
                builder.append(this._maxThreadCount);
            }
            if (this._minThreadCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minThreadCount=");
                builder.append(this._minThreadCount);
            }
            if (this._queueCapacity != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueCapacity=");
                builder.append(this._queueCapacity);
            }
            if (this._threadFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

