/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.ThreadpoolFlexible;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.threadpool.flexible.ThreadFactory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadpoolFlexibleBuilder
implements Builder<ThreadpoolFlexible> {
    private Long _keepAliveMillis;
    private Integer _maxThreadCount;
    private Integer _minThreadCount;
    private Integer _queueCapacity;
    private ThreadFactory _threadFactory;
    Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = Collections.emptyMap();

    public ThreadpoolFlexibleBuilder() {
    }

    public ThreadpoolFlexibleBuilder(ThreadpoolFlexible base) {
        AugmentationHolder casted;
        this._keepAliveMillis = base.getKeepAliveMillis();
        this._maxThreadCount = base.getMaxThreadCount();
        this._minThreadCount = base.getMinThreadCount();
        this._queueCapacity = base.getQueueCapacity();
        this._threadFactory = base.getThreadFactory();
        if (base instanceof ThreadpoolFlexibleImpl) {
            ThreadpoolFlexibleImpl impl = (ThreadpoolFlexibleImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(casted.augmentations());
        }
    }

    public Long getKeepAliveMillis() {
        return this._keepAliveMillis;
    }

    public Integer getMaxThreadCount() {
        return this._maxThreadCount;
    }

    public Integer getMinThreadCount() {
        return this._minThreadCount;
    }

    public Integer getQueueCapacity() {
        return this._queueCapacity;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkKeepAliveMillisRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ThreadpoolFlexibleBuilder setKeepAliveMillis(Long value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkKeepAliveMillisRange(value);
        }
        this._keepAliveMillis = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _keepAliveMillis_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
        return ret;
    }

    private static void checkMaxThreadCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setMaxThreadCount(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkMaxThreadCountRange(value);
        }
        this._maxThreadCount = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _maxThreadCount_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkMinThreadCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setMinThreadCount(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkMinThreadCountRange(value);
        }
        this._minThreadCount = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _minThreadCount_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkQueueCapacityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setQueueCapacity(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkQueueCapacityRange(value);
        }
        this._queueCapacity = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _queueCapacity_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    public ThreadpoolFlexibleBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public ThreadpoolFlexibleBuilder addAugmentation(Class<? extends Augmentation<ThreadpoolFlexible>> augmentationType, Augmentation<ThreadpoolFlexible> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadpoolFlexibleBuilder removeAugmentation(Class<? extends Augmentation<ThreadpoolFlexible>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ThreadpoolFlexible build() {
        return new ThreadpoolFlexibleImpl(this);
    }

    private static final class ThreadpoolFlexibleImpl
    implements ThreadpoolFlexible {
        private final Long _keepAliveMillis;
        private final Integer _maxThreadCount;
        private final Integer _minThreadCount;
        private final Integer _queueCapacity;
        private final ThreadFactory _threadFactory;
        private Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ThreadpoolFlexible> getImplementedInterface() {
            return ThreadpoolFlexible.class;
        }

        private ThreadpoolFlexibleImpl(ThreadpoolFlexibleBuilder base) {
            this._keepAliveMillis = base.getKeepAliveMillis();
            this._maxThreadCount = base.getMaxThreadCount();
            this._minThreadCount = base.getMinThreadCount();
            this._queueCapacity = base.getQueueCapacity();
            this._threadFactory = base.getThreadFactory();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getKeepAliveMillis() {
            return this._keepAliveMillis;
        }

        @Override
        public Integer getMaxThreadCount() {
            return this._maxThreadCount;
        }

        @Override
        public Integer getMinThreadCount() {
            return this._minThreadCount;
        }

        @Override
        public Integer getQueueCapacity() {
            return this._queueCapacity;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._keepAliveMillis == null ? 0 : this._keepAliveMillis.hashCode());
            result = 31 * result + (this._maxThreadCount == null ? 0 : this._maxThreadCount.hashCode());
            result = 31 * result + (this._minThreadCount == null ? 0 : this._minThreadCount.hashCode());
            result = 31 * result + (this._queueCapacity == null ? 0 : this._queueCapacity.hashCode());
            result = 31 * result + (this._threadFactory == null ? 0 : this._threadFactory.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadpoolFlexible.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadpoolFlexible other = (ThreadpoolFlexible)obj;
            if (this._keepAliveMillis == null ? other.getKeepAliveMillis() != null : !this._keepAliveMillis.equals(other.getKeepAliveMillis())) {
                return false;
            }
            if (this._maxThreadCount == null ? other.getMaxThreadCount() != null : !this._maxThreadCount.equals(other.getMaxThreadCount())) {
                return false;
            }
            if (this._minThreadCount == null ? other.getMinThreadCount() != null : !this._minThreadCount.equals(other.getMinThreadCount())) {
                return false;
            }
            if (this._queueCapacity == null ? other.getQueueCapacity() != null : !this._queueCapacity.equals(other.getQueueCapacity())) {
                return false;
            }
            if (this._threadFactory == null ? other.getThreadFactory() != null : !this._threadFactory.equals(other.getThreadFactory())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadpoolFlexibleImpl otherImpl = (ThreadpoolFlexibleImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ThreadpoolFlexible [");
            boolean first = true;
            if (this._keepAliveMillis != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveMillis=");
                builder.append(this._keepAliveMillis);
            }
            if (this._maxThreadCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxThreadCount=");
                builder.append(this._maxThreadCount);
            }
            if (this._minThreadCount != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_minThreadCount=");
                builder.append(this._minThreadCount);
            }
            if (this._queueCapacity != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueCapacity=");
                builder.append(this._queueCapacity);
            }
            if (this._threadFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

