/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.flexible;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.flexible.FlexibleThreadPoolModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:flexible", name="threadpool-impl-flexible", revision="2013-12-01")
public abstract class AbstractFlexibleThreadPoolModule
extends AbstractModule<AbstractFlexibleThreadPoolModule>
implements FlexibleThreadPoolModuleMXBean,
ThreadPoolServiceInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFlexibleThreadPoolModule.class);
    public static final JmxAttribute keepAliveMillisJmxAttribute = new JmxAttribute("KeepAliveMillis");
    private Long keepAliveMillis;
    public static final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    public static final JmxAttribute minThreadCountJmxAttribute = new JmxAttribute("MinThreadCount");
    private Integer minThreadCount;
    public static final JmxAttribute queueCapacityJmxAttribute = new JmxAttribute("QueueCapacity");
    private Integer queueCapacity;
    public static final JmxAttribute maxThreadCountJmxAttribute = new JmxAttribute("MaxThreadCount");
    private Integer maxThreadCount;
    private ThreadFactory threadFactoryDependency;

    public AbstractFlexibleThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractFlexibleThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractFlexibleThreadPoolModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadFactoryServiceInterface.class, this.threadFactory, threadFactoryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    protected final void resolveDependencies() {
        this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, threadFactoryJmxAttribute);
    }

    public boolean canReuseInstance(AbstractFlexibleThreadPoolModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractFlexibleThreadPoolModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.keepAliveMillis, other.keepAliveMillis)) {
            return false;
        }
        if (!Objects.deepEquals(this.threadFactory, other.threadFactory)) {
            return false;
        }
        if (this.threadFactory != null && !this.dependencyResolver.canReuseDependency(this.threadFactory, threadFactoryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.minThreadCount, other.minThreadCount)) {
            return false;
        }
        if (!Objects.deepEquals(this.queueCapacity, other.queueCapacity)) {
            return false;
        }
        return Objects.deepEquals(this.maxThreadCount, other.maxThreadCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFlexibleThreadPoolModule that = (AbstractFlexibleThreadPoolModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public Long getKeepAliveMillis() {
        return this.keepAliveMillis;
    }

    @Override
    public void setKeepAliveMillis(Long keepAliveMillis) {
        this.keepAliveMillis = keepAliveMillis;
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Integer getMinThreadCount() {
        return this.minThreadCount;
    }

    @Override
    public void setMinThreadCount(Integer minThreadCount) {
        this.minThreadCount = minThreadCount;
    }

    @Override
    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    @Override
    @Description(value="Capacity of queue that holds waiting tasks")
    public void setQueueCapacity(Integer queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    @Override
    public Integer getMaxThreadCount() {
        return this.maxThreadCount;
    }

    @Override
    public void setMaxThreadCount(Integer maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

