/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.ThreadpoolFlexible;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.threadpool.flexible.ThreadFactory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadpoolFlexibleBuilder
implements Builder<ThreadpoolFlexible> {
    private Long _keepAliveMillis;
    private Integer _maxThreadCount;
    private Integer _minThreadCount;
    private Integer _queueCapacity;
    private ThreadFactory _threadFactory;
    Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = Collections.emptyMap();

    public ThreadpoolFlexibleBuilder() {
    }

    public ThreadpoolFlexibleBuilder(ThreadpoolFlexible base) {
        AugmentationHolder casted;
        this._keepAliveMillis = base.getKeepAliveMillis();
        this._maxThreadCount = base.getMaxThreadCount();
        this._minThreadCount = base.getMinThreadCount();
        this._queueCapacity = base.getQueueCapacity();
        this._threadFactory = base.getThreadFactory();
        if (base instanceof ThreadpoolFlexibleImpl) {
            ThreadpoolFlexibleImpl impl = (ThreadpoolFlexibleImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(casted.augmentations());
        }
    }

    public Long getKeepAliveMillis() {
        return this._keepAliveMillis;
    }

    public Integer getMaxThreadCount() {
        return this._maxThreadCount;
    }

    public Integer getMinThreadCount() {
        return this._minThreadCount;
    }

    public Integer getQueueCapacity() {
        return this._queueCapacity;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkKeepAliveMillisRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ThreadpoolFlexibleBuilder setKeepAliveMillis(Long value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkKeepAliveMillisRange(value);
        }
        this._keepAliveMillis = value;
        return this;
    }

    private static void checkMaxThreadCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setMaxThreadCount(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkMaxThreadCountRange(value);
        }
        this._maxThreadCount = value;
        return this;
    }

    private static void checkMinThreadCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setMinThreadCount(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkMinThreadCountRange(value);
        }
        this._minThreadCount = value;
        return this;
    }

    private static void checkQueueCapacityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolFlexibleBuilder setQueueCapacity(Integer value) {
        if (value != null) {
            ThreadpoolFlexibleBuilder.checkQueueCapacityRange(value);
        }
        this._queueCapacity = value;
        return this;
    }

    public ThreadpoolFlexibleBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public ThreadpoolFlexibleBuilder addAugmentation(Class<? extends Augmentation<ThreadpoolFlexible>> augmentationType, Augmentation<ThreadpoolFlexible> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadpoolFlexibleBuilder removeAugmentation(Class<? extends Augmentation<ThreadpoolFlexible>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ThreadpoolFlexible build() {
        return new ThreadpoolFlexibleImpl(this);
    }

    private static final class ThreadpoolFlexibleImpl
    implements ThreadpoolFlexible {
        private final Long _keepAliveMillis;
        private final Integer _maxThreadCount;
        private final Integer _minThreadCount;
        private final Integer _queueCapacity;
        private final ThreadFactory _threadFactory;
        private Map<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ThreadpoolFlexible> getImplementedInterface() {
            return ThreadpoolFlexible.class;
        }

        private ThreadpoolFlexibleImpl(ThreadpoolFlexibleBuilder base) {
            this._keepAliveMillis = base.getKeepAliveMillis();
            this._maxThreadCount = base.getMaxThreadCount();
            this._minThreadCount = base.getMinThreadCount();
            this._queueCapacity = base.getQueueCapacity();
            this._threadFactory = base.getThreadFactory();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getKeepAliveMillis() {
            return this._keepAliveMillis;
        }

        @Override
        public Integer getMaxThreadCount() {
            return this._maxThreadCount;
        }

        @Override
        public Integer getMinThreadCount() {
            return this._minThreadCount;
        }

        @Override
        public Integer getQueueCapacity() {
            return this._queueCapacity;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        public <E extends Augmentation<ThreadpoolFlexible>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._keepAliveMillis);
            result = 31 * result + Objects.hashCode(this._maxThreadCount);
            result = 31 * result + Objects.hashCode(this._minThreadCount);
            result = 31 * result + Objects.hashCode(this._queueCapacity);
            result = 31 * result + Objects.hashCode(this._threadFactory);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadpoolFlexible.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadpoolFlexible other = (ThreadpoolFlexible)obj;
            if (!Objects.equals(this._keepAliveMillis, other.getKeepAliveMillis())) {
                return false;
            }
            if (!Objects.equals(this._maxThreadCount, other.getMaxThreadCount())) {
                return false;
            }
            if (!Objects.equals(this._minThreadCount, other.getMinThreadCount())) {
                return false;
            }
            if (!Objects.equals(this._queueCapacity, other.getQueueCapacity())) {
                return false;
            }
            if (!Objects.equals(this._threadFactory, other.getThreadFactory())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadpoolFlexibleImpl otherImpl = (ThreadpoolFlexibleImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadpoolFlexible>>, Augmentation<ThreadpoolFlexible>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ThreadpoolFlexible [";
            StringBuilder builder = new StringBuilder(name);
            if (this._keepAliveMillis != null) {
                builder.append("_keepAliveMillis=");
                builder.append(this._keepAliveMillis);
                builder.append(", ");
            }
            if (this._maxThreadCount != null) {
                builder.append("_maxThreadCount=");
                builder.append(this._maxThreadCount);
                builder.append(", ");
            }
            if (this._minThreadCount != null) {
                builder.append("_minThreadCount=");
                builder.append(this._minThreadCount);
                builder.append(", ");
            }
            if (this._queueCapacity != null) {
                builder.append("_queueCapacity=");
                builder.append(this._queueCapacity);
                builder.append(", ");
            }
            if (this._threadFactory != null) {
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

