/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.threadpool.flexible;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.flexible.rev131201.modules.module.configuration.threadpool.flexible.ThreadFactory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadFactoryBuilder
implements Builder<ThreadFactory> {
    private Object _name;
    private Class<? extends ServiceType> _type;
    Map<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>> augmentation = Collections.emptyMap();

    public ThreadFactoryBuilder() {
    }

    public ThreadFactoryBuilder(ServiceRef arg) {
        this._type = arg.getType();
        this._name = arg.getName();
    }

    public ThreadFactoryBuilder(ThreadFactory base) {
        AugmentationHolder casted;
        this._name = base.getName();
        this._type = base.getType();
        if (base instanceof ThreadFactoryImpl) {
            ThreadFactoryImpl impl = (ThreadFactoryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceRef) {
            this._type = ((ServiceRef)arg).getType();
            this._name = ((ServiceRef)arg).getName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceRef] \nbut was: " + arg);
        }
    }

    public Object getName() {
        return this._name;
    }

    public Class<? extends ServiceType> getType() {
        return this._type;
    }

    public <E extends Augmentation<ThreadFactory>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ThreadFactoryBuilder setName(Object value) {
        this._name = value;
        return this;
    }

    public ThreadFactoryBuilder setType(Class<? extends ServiceType> value) {
        this._type = value;
        return this;
    }

    public ThreadFactoryBuilder addAugmentation(Class<? extends Augmentation<ThreadFactory>> augmentationType, Augmentation<ThreadFactory> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadFactoryBuilder removeAugmentation(Class<? extends Augmentation<ThreadFactory>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ThreadFactory build() {
        return new ThreadFactoryImpl(this);
    }

    private static final class ThreadFactoryImpl
    implements ThreadFactory {
        private final Object _name;
        private final Class<? extends ServiceType> _type;
        private Map<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ThreadFactory> getImplementedInterface() {
            return ThreadFactory.class;
        }

        private ThreadFactoryImpl(ThreadFactoryBuilder base) {
            this._name = base.getName();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>>(base.augmentation);
                }
            }
        }

        public Object getName() {
            return this._name;
        }

        public Class<? extends ServiceType> getType() {
            return this._type;
        }

        public <E extends Augmentation<ThreadFactory>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadFactory.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadFactory other = (ThreadFactory)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadFactoryImpl otherImpl = (ThreadFactoryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadFactory>>, Augmentation<ThreadFactory>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ThreadFactory [";
            StringBuilder builder = new StringBuilder(name);
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

