/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.threadpool.ThreadPool;
import org.opendaylight.controller.config.yang.threadpool.EventBusServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.AsyncEventBusModuleMXBean;
import org.opendaylight.controller.config.yang.threadpool.impl.AsyncEventBusRuntimeRegistrator;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl", name="threadpool-impl", revision="2013-04-05")
public abstract class AbstractAsyncEventBusModule
extends AbstractModule<AbstractAsyncEventBusModule>
implements AsyncEventBusModuleMXBean,
EventBusServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncEventBusModule.class);
    public static final JmxAttribute threadpoolJmxAttribute = new JmxAttribute("Threadpool");
    private ObjectName threadpool;
    private AsyncEventBusRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private ThreadPool threadpoolDependency;

    public AbstractAsyncEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractAsyncEventBusModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractAsyncEventBusModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public AsyncEventBusRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new AsyncEventBusRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadPoolServiceInterface.class, this.threadpool, threadpoolJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadPool getThreadpoolDependency() {
        return this.threadpoolDependency;
    }

    protected final void resolveDependencies() {
        this.threadpoolDependency = (ThreadPool)this.dependencyResolver.resolveInstance(ThreadPool.class, this.threadpool, threadpoolJmxAttribute);
    }

    public boolean canReuseInstance(AbstractAsyncEventBusModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractAsyncEventBusModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.threadpool, other.threadpool)) {
            return false;
        }
        return this.threadpool == null || this.dependencyResolver.canReuseDependency(this.threadpool, threadpoolJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAsyncEventBusModule that = (AbstractAsyncEventBusModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getThreadpool() {
        return this.threadpool;
    }

    @Override
    @RequireInterface(value=ThreadPoolServiceInterface.class)
    public void setThreadpool(ObjectName threadpool) {
        this.threadpool = threadpool;
    }

    public Logger getLogger() {
        return LOG;
    }
}

