/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.fixed;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.fixed.FixedThreadPoolModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:fixed", name="threadpool-impl-fixed", revision="2013-12-01")
public abstract class AbstractFixedThreadPoolModuleFactory
implements ModuleFactory {
    public static final String NAME = "threadpool-fixed";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final String getImplementationName() {
        return NAME;
    }

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        FixedThreadPoolModule oldModule;
        try {
            oldModule = (FixedThreadPoolModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(dependencyResolver, old, bundleContext);
        }
        FixedThreadPoolModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setThreadFactory(oldModule.getThreadFactory());
        module.setMaxThreadCount(oldModule.getMaxThreadCount());
        return module;
    }

    public FixedThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, FixedThreadPoolModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new FixedThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public FixedThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new FixedThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public FixedThreadPoolModule handleChangedClass(DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        String instanceName = ((ModuleIdentifier)old.getModule().getIdentifier()).getInstanceName();
        FixedThreadPoolModule newModule = new FixedThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
        Module oldModule = old.getModule();
        Class<?> oldModuleClass = oldModule.getClass();
        newModule.setThreadFactory((ObjectName)oldModuleClass.getMethod("getThreadFactory", new Class[0]).invoke((Object)oldModule, new Object[0]));
        newModule.setMaxThreadCount((Integer)oldModuleClass.getMethod("getMaxThreadCount", new Class[0]).invoke((Object)oldModule, new Object[0]));
        return newModule;
    }

    @Deprecated
    public FixedThreadPoolModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<FixedThreadPoolModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<FixedThreadPoolModule>();
    }

    static {
        HashSet<Class<ThreadPoolServiceInterface>> serviceIfcs2 = new HashSet<Class<ThreadPoolServiceInterface>>();
        serviceIfcs2.add(ThreadPoolServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

