/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.scheduled;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.threadpool.ScheduledThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.scheduled.ScheduledThreadPoolModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:scheduled", name="threadpool-impl-scheduled", revision="2013-12-01")
public abstract class AbstractScheduledThreadPoolModule
extends AbstractModule<AbstractScheduledThreadPoolModule>
implements ScheduledThreadPoolModuleMXBean,
ScheduledThreadPoolServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractScheduledThreadPoolModule.class);
    public static final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    public static final JmxAttribute maxThreadCountJmxAttribute = new JmxAttribute("MaxThreadCount");
    private Integer maxThreadCount;
    private ThreadFactory threadFactoryDependency;

    public AbstractScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractScheduledThreadPoolModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(ThreadFactoryServiceInterface.class, this.threadFactory, threadFactoryJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    protected final void resolveDependencies() {
        this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, threadFactoryJmxAttribute);
    }

    public boolean canReuseInstance(AbstractScheduledThreadPoolModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractScheduledThreadPoolModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.threadFactory, other.threadFactory)) {
            return false;
        }
        if (this.threadFactory != null && !this.dependencyResolver.canReuseDependency(this.threadFactory, threadFactoryJmxAttribute)) {
            return false;
        }
        return Objects.deepEquals(this.maxThreadCount, other.maxThreadCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractScheduledThreadPoolModule that = (AbstractScheduledThreadPoolModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Integer getMaxThreadCount() {
        return this.maxThreadCount;
    }

    @Override
    public void setMaxThreadCount(Integer maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public Logger getLogger() {
        return LOG;
    }
}

