/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.scheduled.rev131201.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.scheduled.rev131201.modules.module.configuration.ThreadpoolScheduled;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.threadpool.impl.scheduled.rev131201.modules.module.configuration.threadpool.scheduled.ThreadFactory;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadpoolScheduledBuilder
implements Builder<ThreadpoolScheduled> {
    private Integer _maxThreadCount;
    private ThreadFactory _threadFactory;
    Map<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>> augmentation = Collections.emptyMap();

    public ThreadpoolScheduledBuilder() {
    }

    public ThreadpoolScheduledBuilder(ThreadpoolScheduled base) {
        AugmentationHolder casted;
        this._maxThreadCount = base.getMaxThreadCount();
        this._threadFactory = base.getThreadFactory();
        if (base instanceof ThreadpoolScheduledImpl) {
            ThreadpoolScheduledImpl impl = (ThreadpoolScheduledImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>>(casted.augmentations());
        }
    }

    public Integer getMaxThreadCount() {
        return this._maxThreadCount;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public <E extends Augmentation<ThreadpoolScheduled>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxThreadCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadpoolScheduledBuilder setMaxThreadCount(Integer value) {
        if (value != null) {
            ThreadpoolScheduledBuilder.checkMaxThreadCountRange(value);
        }
        this._maxThreadCount = value;
        return this;
    }

    public ThreadpoolScheduledBuilder setThreadFactory(ThreadFactory value) {
        this._threadFactory = value;
        return this;
    }

    public ThreadpoolScheduledBuilder addAugmentation(Class<? extends Augmentation<ThreadpoolScheduled>> augmentationType, Augmentation<ThreadpoolScheduled> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadpoolScheduledBuilder removeAugmentation(Class<? extends Augmentation<ThreadpoolScheduled>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ThreadpoolScheduled build() {
        return new ThreadpoolScheduledImpl(this);
    }

    private static final class ThreadpoolScheduledImpl
    implements ThreadpoolScheduled {
        private final Integer _maxThreadCount;
        private final ThreadFactory _threadFactory;
        private Map<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ThreadpoolScheduled> getImplementedInterface() {
            return ThreadpoolScheduled.class;
        }

        private ThreadpoolScheduledImpl(ThreadpoolScheduledBuilder base) {
            this._maxThreadCount = base.getMaxThreadCount();
            this._threadFactory = base.getThreadFactory();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxThreadCount() {
            return this._maxThreadCount;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this._threadFactory;
        }

        public <E extends Augmentation<ThreadpoolScheduled>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxThreadCount);
            result = 31 * result + Objects.hashCode(this._threadFactory);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ThreadpoolScheduled.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ThreadpoolScheduled other = (ThreadpoolScheduled)obj;
            if (!Objects.equals(this._maxThreadCount, other.getMaxThreadCount())) {
                return false;
            }
            if (!Objects.equals(this._threadFactory, other.getThreadFactory())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadpoolScheduledImpl otherImpl = (ThreadpoolScheduledImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ThreadpoolScheduled>>, Augmentation<ThreadpoolScheduled>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ThreadpoolScheduled [";
            StringBuilder builder = new StringBuilder(name);
            if (this._maxThreadCount != null) {
                builder.append("_maxThreadCount=");
                builder.append(this._maxThreadCount);
                builder.append(", ");
            }
            if (this._threadFactory != null) {
                builder.append("_threadFactory=");
                builder.append(this._threadFactory);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

