/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topology.web;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Host;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.packet.address.EthernetAddress;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.ObjectReader;
import org.opendaylight.controller.sal.utils.ObjectWriter;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.Switch;
import org.opendaylight.controller.switchmanager.SwitchConfig;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.web.DaylightWebUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class Topology
implements IObjectReader,
IConfigurationAware {
    private static String ROOT = GlobalConstants.STARTUPHOME.toString();
    private String topologyWebFileName = null;
    protected Map<String, Map<String, Map<String, Object>>> metaCache = new HashMap<String, Map<String, Map<String, Object>>>();
    protected Map<String, Map<String, Object>> stagedNodes;
    protected Map<String, Map<String, Object>> newNodes;
    protected Map<String, Integer> metaNodeHash = new HashMap<String, Integer>();
    protected Map<String, Integer> metaHostHash = new HashMap<String, Integer>();
    protected Map<String, Integer> metaNodeSingleHash = new HashMap<String, Integer>();
    protected Map<String, Integer> metaNodeConfigurationHash = new HashMap<String, Integer>();

    public Topology() {
        ServiceHelper.registerGlobalService(IConfigurationAware.class, (Object)this, null);
        this.topologyWebFileName = ROOT + "topologyCache.sav";
        this.loadConfiguration();
    }

    @RequestMapping(value={"/visual.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<Map<String, Object>> getLinkData(@RequestParam(required=false) String container, HttpServletRequest request) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        if (privilege == Privilege.NONE) {
            return null;
        }
        ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)containerName, (Object)this);
        if (topologyManager == null) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            return null;
        }
        Map nodeEdges = topologyManager.getNodeEdges();
        Map hostEdges = topologyManager.getNodesWithNodeConnectorHost();
        int hostEdgesHashCode = this.getHostHashCode(hostEdges, topologyManager);
        List nodes = switchManager.getNetworkDevices();
        ArrayList<SwitchConfig> switchConfigurations = new ArrayList<SwitchConfig>();
        for (Switch sw : nodes) {
            Node n = sw.getNode();
            SwitchConfig config = switchManager.getSwitchConfig(n.toString());
            switchConfigurations.add(config);
        }
        if (!this.metaCache.containsKey(containerName)) {
            this.metaCache.put(containerName, new HashMap());
            this.metaNodeHash.put(containerName, null);
            this.metaHostHash.put(containerName, null);
            this.metaNodeSingleHash.put(containerName, null);
            this.metaNodeConfigurationHash.put(containerName, null);
        }
        if (this.metaNodeHash.get(containerName) != null && this.metaHostHash.get(containerName) != null && this.metaNodeSingleHash.get(containerName) != null && this.metaNodeConfigurationHash.get(containerName) != null && this.metaNodeHash.get(containerName).equals(nodeEdges.hashCode()) && this.metaHostHash.get(containerName).equals(hostEdgesHashCode) && this.metaNodeSingleHash.get(containerName).equals(nodes.hashCode()) && this.metaNodeConfigurationHash.get(containerName).equals(switchConfigurations.hashCode())) {
            return this.metaCache.get(containerName).values();
        }
        this.metaNodeHash.put(containerName, nodeEdges.hashCode());
        this.metaHostHash.put(containerName, hostEdgesHashCode);
        this.metaNodeSingleHash.put(containerName, nodes.hashCode());
        this.metaNodeConfigurationHash.put(containerName, switchConfigurations.hashCode());
        this.stagedNodes = new HashMap<String, Map<String, Object>>();
        this.newNodes = new HashMap<String, Map<String, Object>>();
        this.addNodes(nodeEdges, topologyManager, switchManager, containerName);
        this.addSingleNodes(nodes, switchManager, containerName);
        this.addHostNodes(hostEdges, topologyManager, containerName);
        this.repositionTopology(containerName);
        return this.metaCache.get(containerName).values();
    }

    private void addNodes(Map<Node, Set<Edge>> nodeEdges, ITopologyManager topology, ISwitchManager switchManager, String containerName) {
        Bandwidth bandwidth = new Bandwidth(0);
        Map properties = topology.getEdges();
        for (Map.Entry<Node, Set<Edge>> e : nodeEdges.entrySet()) {
            Node n = e.getKey();
            String description = this.getNodeDesc(n, switchManager);
            NodeBean node = this.createNodeBean(description, n);
            if (this.nodeIgnore(n)) continue;
            LinkedList<Map<String, Object>> adjacencies = new LinkedList<Map<String, Object>>();
            Set<Edge> links = e.getValue();
            for (Edge link : links) {
                Set props;
                if (this.edgeIgnore(link) || (props = (Set)properties.get(link)) == null) continue;
                for (Property p : props) {
                    if (!(p instanceof Bandwidth)) continue;
                    bandwidth = (Bandwidth)p;
                    break;
                }
                NodeConnector headNodeConnector = link.getHeadNodeConnector();
                NodeConnector tailNodeConnector = link.getTailNodeConnector();
                String headDescription = this.getNodeConnectorDescription(headNodeConnector, switchManager);
                String tailDescription = this.getNodeConnectorDescription(tailNodeConnector, switchManager);
                String headPortDescription = this.getNodeConnectorPortDescription(headNodeConnector, switchManager);
                String tailPortDescription = this.getNodeConnectorPortDescription(tailNodeConnector, switchManager);
                EdgeBean edge = new EdgeBean(link, bandwidth, headDescription, tailDescription, headPortDescription, tailPortDescription);
                adjacencies.add(edge.out());
            }
            node.setLinks(adjacencies);
            if (this.metaCache.get(containerName).containsKey(node.id())) {
                Map<String, Object> nodeEntry = this.metaCache.get(containerName).get(node.id());
                Map data = (Map)nodeEntry.get("data");
                data.put("$desc", description);
                nodeEntry.put("data", data);
                nodeEntry.put("adjacencies", adjacencies);
                this.stagedNodes.put(node.id(), nodeEntry);
                continue;
            }
            this.newNodes.put(node.id(), node.out());
        }
    }

    private boolean nodeIgnore(Node node) {
        String nodeType = node.getType();
        return nodeType.equals(Node.NodeIDType.PRODUCTION);
    }

    private boolean edgeIgnore(Edge edge) {
        NodeConnector headNodeConnector = edge.getHeadNodeConnector();
        Node headNode = headNodeConnector.getNode();
        if (this.nodeIgnore(headNode)) {
            return true;
        }
        NodeConnector tailNodeConnector = edge.getTailNodeConnector();
        Node tailNode = tailNodeConnector.getNode();
        return this.nodeIgnore(tailNode);
    }

    protected NodeBean createNodeBean(String description, Node node) {
        String name = this.getDescription(description, node);
        return new NodeBean(node.toString(), name, "switch");
    }

    private String getDescription(String description, Node node) {
        String name = description == null || description.trim().isEmpty() || description.equalsIgnoreCase("none") ? node.toString() : description;
        return name;
    }

    private String getNodeConnectorDescription(NodeConnector nodeConnector, ISwitchManager switchManager) {
        Node node = nodeConnector.getNode();
        String name = this.getDescription(this.getNodeDesc(node, switchManager), node);
        return name;
    }

    private String getNodeConnectorPortDescription(NodeConnector nodeConnector, ISwitchManager switchManager) {
        Name ncName = (Name)switchManager.getNodeConnectorProp(nodeConnector, "name");
        String nodeConnectorName = nodeConnector.getNodeConnectorIDString();
        if (ncName != null) {
            nodeConnectorName = ncName.getValue();
        }
        return nodeConnectorName;
    }

    private void addSingleNodes(List<Switch> nodes, ISwitchManager switchManager, String containerName) {
        if (nodes == null) {
            return;
        }
        for (Switch sw : nodes) {
            Node n = sw.getNode();
            if (this.nodeIgnore(n)) continue;
            String description = this.getNodeDesc(n, switchManager);
            if (this.stagedNodes.containsKey(n.toString()) && this.metaCache.get(containerName).containsKey(n.toString()) || this.newNodes.containsKey(n.toString())) continue;
            NodeBean node = this.createNodeBean(description, n);
            if (this.metaCache.get(containerName).containsKey(node.id()) && !this.stagedNodes.containsKey(node.id())) {
                Map<String, Object> nodeEntry = this.metaCache.get(containerName).get(node.id());
                Map data = (Map)nodeEntry.get("data");
                data.put("$desc", description);
                nodeEntry.put("data", data);
                nodeEntry.put("adjacencies", new LinkedList());
                this.stagedNodes.put(node.id(), nodeEntry);
                continue;
            }
            this.newNodes.put(node.id(), node.out());
        }
    }

    private int getHostHashCode(Map<Node, Set<NodeConnector>> hostEdges, ITopologyManager topology) {
        ArrayList hosts = new ArrayList();
        for (Set<NodeConnector> nodeConnectors : hostEdges.values()) {
            for (NodeConnector nodeConnector : nodeConnectors) {
                List theseHosts = topology.getHostsAttachedToNodeConnector(nodeConnector);
                hosts.addAll(theseHosts);
            }
        }
        return hosts.hashCode();
    }

    private void addHostNodes(Map<Node, Set<NodeConnector>> hostEdges, ITopologyManager topology, String containerName) {
        for (Map.Entry<Node, Set<NodeConnector>> e : hostEdges.entrySet()) {
            for (NodeConnector connector : e.getValue()) {
                List hosts = topology.getHostsAttachedToNodeConnector(connector);
                for (Host host : hosts) {
                    EthernetAddress dmac = (EthernetAddress)host.getDataLayerAddress();
                    ByteBuffer addressByteBuffer = ByteBuffer.allocate(8);
                    addressByteBuffer.putShort((short)0);
                    addressByteBuffer.put(dmac.getValue());
                    addressByteBuffer.rewind();
                    long hid = addressByteBuffer.getLong();
                    String hostId = String.valueOf(hid);
                    NodeBean hostBean = new NodeBean(hostId, host.getNetworkAddressAsString(), "host");
                    LinkedList<Map<String, Object>> adjacencies = new LinkedList<Map<String, Object>>();
                    EdgeBean edge = new EdgeBean(connector, hid);
                    adjacencies.add(edge.out());
                    hostBean.setLinks(adjacencies);
                    if (this.metaCache.get(containerName).containsKey(hostId)) {
                        Map<String, Object> hostEntry = this.metaCache.get(containerName).get(hostId);
                        hostEntry.put("adjacencies", adjacencies);
                        this.stagedNodes.put(hostId, hostEntry);
                        continue;
                    }
                    this.newNodes.put(String.valueOf(hid), hostBean.out());
                }
            }
        }
    }

    private void repositionTopology(String containerName) {
        SparseMultigraph graph = new SparseMultigraph();
        this.metaCache.get(containerName).clear();
        this.metaCache.get(containerName).putAll(this.stagedNodes);
        this.metaCache.get(containerName).putAll(this.newNodes);
        for (Map<String, Object> on : this.metaCache.get(containerName).values()) {
            graph.addVertex((Object)on.toString());
            List adjacencies = (List)on.get("adjacencies");
            for (Map adj : adjacencies) {
                graph.addEdge((Object)adj.toString(), (Object)adj.get("nodeFrom").toString(), (Object)adj.get("nodeTo").toString());
            }
        }
        CircleLayout layout = new CircleLayout((Graph)graph);
        layout.setSize(new Dimension(1200, 365));
        for (Map.Entry<String, Map<String, Object>> v : this.newNodes.entrySet()) {
            Double x = layout.transform((Object)v.getKey()).getX();
            Double y = layout.transform((Object)v.getKey()).getY();
            HashMap nodeData = (HashMap)v.getValue().get("data");
            nodeData.put("$x", x - 600.0 + "");
            nodeData.put("$y", y - 225.0 + "");
            this.newNodes.get(v.getKey()).put("data", nodeData);
        }
    }

    @RequestMapping(value={"/node/{nodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> post(@PathVariable String nodeId, @RequestParam(required=true) String x, @RequestParam(required=true) String y, @RequestParam(required=false) String container, HttpServletRequest request) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        if (privilege != Privilege.WRITE) {
            return new HashMap<String, Object>();
        }
        String id = new String(nodeId);
        if (!this.metaCache.get(containerName).containsKey(id)) {
            return null;
        }
        Map<String, Object> node = this.metaCache.get(containerName).get(id);
        Map data = (Map)node.get("data");
        data.put("$x", x);
        data.put("$y", y);
        node.put("data", data);
        return node;
    }

    private void loadConfiguration() {
        ObjectReader objReader = new ObjectReader();
        this.metaCache = (Map)objReader.read((IObjectReader)this, this.topologyWebFileName);
        if (this.metaCache == null) {
            this.metaCache = new HashMap<String, Map<String, Map<String, Object>>>();
        }
    }

    public Status saveConfiguration() {
        ObjectWriter objWriter = new ObjectWriter();
        objWriter.write(this.metaCache, this.topologyWebFileName);
        return new Status(StatusCode.SUCCESS, null);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    private String getNodeDesc(Node node, ISwitchManager switchManager) {
        Description desc = (Description)switchManager.getNodeProp(node, "description");
        return desc == null ? "" : desc.getValue();
    }

    protected class NodeType {
        public static final String NODE = "switch";
        public static final String HOST = "host";

        protected NodeType() {
        }
    }

    protected class EdgeBean {
        protected NodeConnector source;
        protected NodeConnector destination;
        protected Map<String, String> data = new HashMap<String, String>();
        protected Long hostId;

        public EdgeBean() {
        }

        public EdgeBean(Edge link, Bandwidth bandwidth, String headDescription, String tailDescription, String headPortDescription, String tailPortDescription) {
            this();
            this.source = link.getHeadNodeConnector();
            this.destination = link.getTailNodeConnector();
            this.data.put("$bandwidth", bandwidth.toString());
            this.data.put("$color", this.bandwidthColor(bandwidth));
            this.data.put("$nodeToPort", this.destination.getID().toString());
            this.data.put("$nodeFromPort", this.source.getID().toString());
            this.data.put("$descFrom", headDescription);
            this.data.put("$descTo", tailDescription);
            this.data.put("$nodeFromPortName", this.source.toString());
            this.data.put("$nodeToPortName", this.destination.toString());
            this.data.put("$nodeFromPortDescription", headPortDescription);
            this.data.put("$nodeToPortDescription", tailPortDescription);
        }

        public EdgeBean(NodeConnector connector, Long hostId) {
            this();
            this.source = null;
            this.destination = connector;
            this.hostId = hostId;
            this.data.put("$bandwidth", "N/A");
            this.data.put("$color", this.bandwidthColor(new Bandwidth(0)));
            this.data.put("$nodeToPort", connector.getNodeConnectorIDString());
            this.data.put("$nodeFromPort", connector.getNodeConnectorIDString());
            this.data.put("$descTo", "");
            this.data.put("$descFrom", "");
            this.data.put("$nodeToPortName", "");
            this.data.put("$nodeFromPortName", "");
        }

        public Map<String, Object> out() {
            HashMap<String, Object> edge = new HashMap<String, Object>();
            edge.put("data", this.data);
            if (this.source == null) {
                edge.put("nodeFrom", String.valueOf(this.hostId));
            } else {
                edge.put("nodeFrom", this.source.getNode().toString());
            }
            edge.put("nodeTo", this.destination.getNode().toString());
            return edge;
        }

        private String bandwidthColor(Bandwidth bandwidth) {
            String color = null;
            long bandwidthValue = bandwidth.getValue();
            if (bandwidthValue == 0L) {
                color = "#000";
            } else if (bandwidthValue < Bandwidth.BW1Kbps) {
                color = "#148AC6";
            } else if (bandwidthValue < Bandwidth.BW1Mbps) {
                color = "#2858A0";
            } else if (bandwidthValue < Bandwidth.BW1Gbps) {
                color = "#009393";
            } else if (bandwidthValue < Bandwidth.BW1Tbps) {
                color = "#C6C014";
            } else if (bandwidthValue < Bandwidth.BW1Pbps) {
                color = "#F9F464";
            }
            return color;
        }
    }

    protected class NodeBean {
        protected String id;
        protected String name;
        protected Map<String, String> data = new HashMap<String, String>();
        protected List<Map<String, Object>> links = new ArrayList<Map<String, Object>>();

        public NodeBean() {
        }

        public NodeBean(String id, String name, String type) {
            this();
            this.id = id;
            this.name = name;
            this.data.put("$desc", name);
            this.data.put("$type", type);
        }

        public void setLinks(List<Map<String, Object>> links) {
            this.links = links;
        }

        public Map<String, Object> out() {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", this.id);
            node.put("name", this.name);
            node.put("data", this.data);
            node.put("adjacencies", this.links);
            return node;
        }

        public String name() {
            return this.name;
        }

        public String id() {
            return this.id;
        }
    }
}

