/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topologymanager.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.topology.IListenTopoUpdates;
import org.opendaylight.controller.sal.topology.ITopologyService;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.ITopologyManagerAware;
import org.opendaylight.controller.topologymanager.ITopologyManagerClusterWideAware;
import org.opendaylight.controller.topologymanager.ITopologyManagerShell;
import org.opendaylight.controller.topologymanager.internal.TopologyManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{TopologyManagerImpl.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(TopologyManagerImpl.class)) {
            Hashtable props = new Hashtable();
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("topologymanager.edgesDB");
            ((Dictionary)props).put("cachenames", propSet);
            c.setInterface(new String[]{IListenTopoUpdates.class.getName(), IInventoryListener.class.getName(), ITopologyManager.class.getName(), ITopologyManagerShell.class.getName(), IConfigurationContainerAware.class.getName(), ICacheUpdateAware.class.getName()}, props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyService.class).setCallbacks("setTopoService", "unsetTopoService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManager.class).setCallbacks("setSwitchManager", "unsetSwitchManager").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyManagerAware.class).setCallbacks("setTopologyManagerAware", "unsetTopologyManagerAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyManagerClusterWideAware.class).setCallbacks("setTopologyManagerClusterWideAware", "unsetTopologyManagerClusterWideAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterContainerService", "unsetClusterContainerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IConfigurationContainerService.class).setCallbacks("setConfigurationContainerService", "unsetConfigurationContainerService").setRequired(true));
        }
    }
}

