/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topologymanager.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.felix.dm.Component;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Host;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.TimeStamp;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.topology.IListenTopoUpdates;
import org.opendaylight.controller.sal.topology.ITopologyService;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.ITopologyManagerAware;
import org.opendaylight.controller.topologymanager.ITopologyManagerClusterWideAware;
import org.opendaylight.controller.topologymanager.ITopologyManagerShell;
import org.opendaylight.controller.topologymanager.TopologyUserLinkConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManagerImpl
implements ICacheUpdateAware<Object, Object>,
ITopologyManager,
ITopologyManagerShell,
IConfigurationContainerAware,
IListenTopoUpdates,
IObjectReader,
IInventoryListener,
CommandProvider {
    protected static final String TOPOEDGESDB = "topologymanager.edgesDB";
    protected static final String TOPOHOSTSDB = "topologymanager.hostsDB";
    protected static final String TOPONODECONNECTORDB = "topologymanager.nodeConnectorDB";
    protected static final String TOPOUSERLINKSDB = "topologymanager.userLinksDB";
    private static final String USER_LINKS_FILE_NAME = "userTopology.conf";
    private static final Logger log = LoggerFactory.getLogger(TopologyManagerImpl.class);
    private static final long PENDING_UPDATE_TIMEOUT = 5000L;
    private ITopologyService topoService;
    private IClusterContainerServices clusterContainerService;
    private IConfigurationContainerService configurationService;
    private ISwitchManager switchManager;
    private ConcurrentMap<Edge, Set<Property>> edgesDB;
    private ConcurrentMap<NodeConnector, Set<Property>> nodeConnectorsDB;
    private ConcurrentMap<NodeConnector, Set<ImmutablePair<Host, Set<Property>>>> hostsDB;
    private Set<ITopologyManagerAware> topologyManagerAware = new CopyOnWriteArraySet<ITopologyManagerAware>();
    private Set<ITopologyManagerClusterWideAware> topologyManagerClusterWideAware = new CopyOnWriteArraySet<ITopologyManagerClusterWideAware>();
    private ConcurrentMap<String, TopologyUserLinkConfig> userLinksDB;
    private BlockingQueue<TopoEdgeUpdate> notifyQ = new LinkedBlockingQueue<TopoEdgeUpdate>();
    private volatile Boolean shuttingDown = false;
    private Thread notifyThread;
    private final Map<NodeConnector, List<PendingUpdateTask>> pendingUpdates = new HashMap<NodeConnector, List<PendingUpdateTask>>();
    private final BlockingQueue<TopoEdgeUpdate> updateQ = new LinkedBlockingQueue<TopoEdgeUpdate>();
    private Timer pendingTimer;
    private Thread updateThread;

    void nonClusterObjectCreate() {
        this.edgesDB = new ConcurrentHashMap<Edge, Set<Property>>();
        this.hostsDB = new ConcurrentHashMap<NodeConnector, Set<ImmutablePair<Host, Set<Property>>>>();
        this.nodeConnectorsDB = new ConcurrentHashMap<NodeConnector, Set<Property>>();
        this.userLinksDB = new ConcurrentHashMap<String, TopologyUserLinkConfig>();
    }

    void setTopologyManagerAware(ITopologyManagerAware s) {
        if (this.topologyManagerAware != null) {
            log.debug("Adding ITopologyManagerAware: {}", (Object)s);
            this.topologyManagerAware.add(s);
        }
    }

    void unsetTopologyManagerAware(ITopologyManagerAware s) {
        if (this.topologyManagerAware != null) {
            log.debug("Removing ITopologyManagerAware: {}", (Object)s);
            this.topologyManagerAware.remove(s);
        }
    }

    void setTopologyManagerClusterWideAware(ITopologyManagerClusterWideAware s) {
        if (this.topologyManagerClusterWideAware != null) {
            log.debug("Adding ITopologyManagerClusterWideAware: {}", (Object)s);
            this.topologyManagerClusterWideAware.add(s);
        }
    }

    void unsetTopologyManagerClusterWideAware(ITopologyManagerClusterWideAware s) {
        if (this.topologyManagerClusterWideAware != null) {
            log.debug("Removing ITopologyManagerClusterWideAware: {}", (Object)s);
            this.topologyManagerClusterWideAware.remove(s);
        }
    }

    void setTopoService(ITopologyService s) {
        log.debug("Adding ITopologyService: {}", (Object)s);
        this.topoService = s;
    }

    void unsetTopoService(ITopologyService s) {
        if (this.topoService == s) {
            log.debug("Removing ITopologyService: {}", (Object)s);
            this.topoService = null;
        }
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    void setSwitchManager(ISwitchManager s) {
        log.debug("Adding ISwitchManager: {}", (Object)s);
        this.switchManager = s;
    }

    void unsetSwitchManager(ISwitchManager s) {
        if (this.switchManager == s) {
            log.debug("Removing ISwitchManager: {}", (Object)s);
            this.switchManager = null;
        }
    }

    void init(Component c) {
        this.allocateCaches();
        this.retrieveCaches();
        String containerName = null;
        Dictionary props = c.getServiceProperties();
        containerName = props != null ? (String)props.get("containerName") : "UNKNOWN";
        this.registerWithOSGIConsole();
        this.loadConfiguration();
        this.shuttingDown = false;
        this.notifyThread = new Thread(new TopologyNotify(this.notifyQ));
        this.pendingTimer = new Timer("Topology Pending Update Timer");
        this.updateThread = new Thread((Runnable)new UpdateTopology(), "Topology Update");
    }

    private void allocateCaches() {
        this.edgesDB = this.allocateCache(TOPOEDGESDB, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        this.hostsDB = this.allocateCache(TOPOHOSTSDB, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        this.nodeConnectorsDB = this.allocateCache(TOPONODECONNECTORDB, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        this.userLinksDB = this.allocateCache(TOPOUSERLINKSDB, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
    }

    private ConcurrentMap<?, ?> allocateCache(String cacheName, Set<IClusterServices.cacheMode> cacheModes) {
        ConcurrentMap cache = null;
        try {
            cache = this.clusterContainerService.createCache(cacheName, cacheModes);
        }
        catch (CacheExistException e) {
            log.debug(cacheName + " cache already exists - destroy and recreate if needed");
        }
        catch (CacheConfigException e) {
            log.error(cacheName + " cache configuration invalid - check cache mode");
        }
        return cache;
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.error("Cluster Services is null, can't retrieve caches.");
            return;
        }
        this.edgesDB = this.clusterContainerService.getCache(TOPOEDGESDB);
        if (this.edgesDB == null) {
            log.error("Failed to get cache for topologymanager.edgesDB");
        }
        this.hostsDB = this.clusterContainerService.getCache(TOPOHOSTSDB);
        if (this.hostsDB == null) {
            log.error("Failed to get cache for topologymanager.hostsDB");
        }
        this.nodeConnectorsDB = this.clusterContainerService.getCache(TOPONODECONNECTORDB);
        if (this.nodeConnectorsDB == null) {
            log.error("Failed to get cache for topologymanager.nodeConnectorDB");
        }
        this.userLinksDB = this.clusterContainerService.getCache(TOPOUSERLINKSDB);
        if (this.userLinksDB == null) {
            log.error("Failed to get cache for topologymanager.userLinksDB");
        }
    }

    void started() {
        this.updateThread.start();
        this.notifyThread.start();
        log.debug("Sollicit topology refresh");
        this.topoService.sollicitRefresh();
    }

    void stop() {
        this.shuttingDown = true;
        this.updateThread.interrupt();
        this.notifyThread.interrupt();
        this.pendingTimer.cancel();
    }

    void destroy() {
        this.updateQ.clear();
        this.updateThread = null;
        this.pendingTimer = null;
        this.notifyQ.clear();
        this.notifyThread = null;
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, USER_LINKS_FILE_NAME)) {
            this.addUserLink((TopologyUserLinkConfig)conf);
        }
    }

    @Override
    public Status saveConfig() {
        return this.saveConfigInternal();
    }

    public Status saveConfigInternal() {
        Status saveStatus = this.configurationService.persistConfiguration(new ArrayList(this.userLinksDB.values()), USER_LINKS_FILE_NAME);
        if (!saveStatus.isSuccess()) {
            return new Status(StatusCode.INTERNALERROR, "Topology save failed: " + saveStatus.getDescription());
        }
        return saveStatus;
    }

    @Override
    public Map<Node, Set<Edge>> getNodeEdges() {
        if (this.edgesDB == null) {
            return null;
        }
        HashMap<Node, Set<Edge>> res = new HashMap<Node, Set<Edge>>();
        for (Edge edge : this.edgesDB.keySet()) {
            Node node = edge.getTailNodeConnector().getNode();
            Set<Edge> nodeEdges = (HashSet<Edge>)res.get(node);
            if (nodeEdges == null) {
                nodeEdges = new HashSet<Edge>();
                res.put(node, nodeEdges);
            }
            nodeEdges.add(edge);
            node = edge.getHeadNodeConnector().getNode();
            nodeEdges = (Set)res.get(node);
            if (nodeEdges == null) {
                nodeEdges = new HashSet();
                res.put(node, nodeEdges);
            }
            nodeEdges.add(edge);
        }
        return res;
    }

    @Override
    public boolean isInternal(NodeConnector p) {
        if (this.nodeConnectorsDB == null) {
            return false;
        }
        return this.nodeConnectorsDB.get(p) != null;
    }

    public boolean isISLink(Edge e) {
        return !this.isProductionLink(e);
    }

    public boolean isProductionLink(Edge e) {
        return e.getHeadNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION) || e.getTailNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION);
    }

    private void crossCheckNodeConnectors(Edge e) {
        NodeConnector nc;
        if (e.getHeadNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION) && (nc = this.updateNCTypeFromSwitchMgr(e.getHeadNodeConnector())) != null) {
            e.setHeadNodeConnector(nc);
        }
        if (e.getTailNodeConnector().getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION) && (nc = this.updateNCTypeFromSwitchMgr(e.getTailNodeConnector())) != null) {
            e.setTailNodeConnector(nc);
        }
    }

    private NodeConnector updateNCTypeFromSwitchMgr(NodeConnector nc) {
        for (Node node : this.switchManager.getNodes()) {
            String nodeName = node.getNodeIDString();
            log.trace("Switch Manager Node Name: {}, NodeConnector Node Name: {}", (Object)nodeName, (Object)nc.getNode().getNodeIDString());
            if (!nodeName.equals(nc.getNode().getNodeIDString())) continue;
            NodeConnector nodeConnector = NodeConnectorCreator.createNodeConnector((String)node.getType(), (Object)nc.getID(), (Node)node);
            return nodeConnector;
        }
        return null;
    }

    @Override
    public Map<Edge, Set<Property>> getEdges() {
        if (this.edgesDB == null) {
            return null;
        }
        HashMap<Edge, Set<Property>> edgeMap = new HashMap<Edge, Set<Property>>();
        for (Map.Entry edgeEntry : this.edgesDB.entrySet()) {
            HashSet props = new HashSet((Collection)edgeEntry.getValue());
            edgeMap.put((Edge)edgeEntry.getKey(), props);
        }
        return edgeMap;
    }

    @Override
    public Set<NodeConnector> getNodeConnectorWithHost() {
        if (this.hostsDB == null) {
            return null;
        }
        return new HashSet<NodeConnector>(this.hostsDB.keySet());
    }

    @Override
    public Map<Node, Set<NodeConnector>> getNodesWithNodeConnectorHost() {
        if (this.hostsDB == null) {
            return null;
        }
        HashMap<Node, Set<NodeConnector>> res = new HashMap<Node, Set<NodeConnector>>();
        for (NodeConnector nc : this.hostsDB.keySet()) {
            Node node = nc.getNode();
            Set<NodeConnector> portSet = res.get(node);
            if (portSet == null) {
                portSet = new HashSet<NodeConnector>();
                res.put(node, portSet);
            }
            portSet.add(nc);
        }
        return res;
    }

    @Override
    public Host getHostAttachedToNodeConnector(NodeConnector port) {
        List<Host> hosts = this.getHostsAttachedToNodeConnector(port);
        if (hosts != null && !hosts.isEmpty()) {
            return hosts.get(0);
        }
        return null;
    }

    @Override
    public List<Host> getHostsAttachedToNodeConnector(NodeConnector p) {
        Set hosts;
        if (this.hostsDB == null || (hosts = (Set)this.hostsDB.get(p)) == null) {
            return null;
        }
        LinkedList<Host> retHosts = new LinkedList<Host>();
        for (ImmutablePair host : hosts) {
            retHosts.add((Host)host.getLeft());
        }
        return retHosts;
    }

    @Override
    public synchronized void updateHostLink(NodeConnector port, Host h, UpdateType t, Set<Property> props) {
        props = props == null ? new HashSet<Property>() : new HashSet<Property>(props);
        ImmutablePair thisHost = new ImmutablePair((Object)h, props);
        HashSet<ImmutablePair> hostSet = (HashSet<ImmutablePair>)this.hostsDB.get(port);
        if (hostSet == null) {
            hostSet = new HashSet<ImmutablePair>();
        }
        switch (t) {
            case ADDED: 
            case CHANGED: {
                hostSet.add(thisHost);
                this.hostsDB.put(port, hostSet);
                break;
            }
            case REMOVED: {
                hostSet.remove(thisHost);
                if (hostSet.isEmpty()) {
                    this.hostsDB.remove(port, hostSet);
                    break;
                }
                this.hostsDB.put(port, hostSet);
            }
        }
    }

    private boolean headNodeConnectorExist(Edge e) {
        NodeConnector head = e.getHeadNodeConnector();
        return this.switchManager.doesNodeConnectorExist(head);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingEvent(Edge e, Set<Property> p, UpdateType t) {
        NodeConnector head = e.getHeadNodeConnector();
        PendingUpdateTask task = new PendingUpdateTask(e, p, t);
        Map<NodeConnector, List<PendingUpdateTask>> map = this.pendingUpdates;
        synchronized (map) {
            List<PendingUpdateTask> list = this.pendingUpdates.get(head);
            if (list == null) {
                list = new LinkedList<PendingUpdateTask>();
                this.pendingUpdates.put(head, list);
            }
            list.add(task);
            this.pendingTimer.schedule((TimerTask)task, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueEventIfPending(Edge e, Set<Property> p, UpdateType t) {
        NodeConnector head = e.getHeadNodeConnector();
        Map<NodeConnector, List<PendingUpdateTask>> map = this.pendingUpdates;
        synchronized (map) {
            List<PendingUpdateTask> list = this.pendingUpdates.get(head);
            if (list != null) {
                log.warn("Enqueue edge update: edge {}, type {}", (Object)e, (Object)t);
                PendingUpdateTask task = new PendingUpdateTask(e, p, t);
                list.add(task);
                this.pendingTimer.schedule((TimerTask)task, 5000L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePendingEvent(PendingUpdateTask t) {
        t.cancel();
        NodeConnector head = t.getHeadNodeConnector();
        boolean removed = false;
        Map<NodeConnector, List<PendingUpdateTask>> map = this.pendingUpdates;
        synchronized (map) {
            List<PendingUpdateTask> list = this.pendingUpdates.get(head);
            if (list != null) {
                removed = list.remove(t);
                if (list.isEmpty()) {
                    this.pendingUpdates.remove(head);
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingEvent(NodeConnector head, boolean doFlush) {
        List<PendingUpdateTask> list;
        Map<NodeConnector, List<PendingUpdateTask>> map = this.pendingUpdates;
        synchronized (map) {
            list = this.pendingUpdates.remove(head);
        }
        if (list != null) {
            for (PendingUpdateTask task : list) {
                if (!task.cancel() || !doFlush) continue;
                task.flush();
            }
            this.pendingTimer.purge();
        }
    }

    private TopoEdgeUpdate edgeUpdate(Edge e, UpdateType type, Set<Property> props) {
        return this.edgeUpdate(e, type, props, false);
    }

    private TopoEdgeUpdate edgeUpdate(Edge e, UpdateType type, Set<Property> props, boolean isPending) {
        if (!type.equals((Object)UpdateType.ADDED) && this.enqueueEventIfPending(e, props, type)) {
            return null;
        }
        switch (type) {
            case ADDED: {
                if (this.edgesDB.containsKey(e)) {
                    log.trace("Skipping redundant edge addition: {}", (Object)e);
                    return null;
                }
                if (!isPending) {
                    if (this.headNodeConnectorExist(e)) {
                        this.removePendingEvent(e.getHeadNodeConnector(), true);
                    } else {
                        log.warn("Ignore edge that contains invalid node connector: {}", (Object)e);
                        this.addPendingEvent(e, props, type);
                        return null;
                    }
                }
                props = props == null ? new HashSet<Property>() : new HashSet<Property>(props);
                this.crossCheckNodeConnectors(e);
                boolean found_create = false;
                for (Property prop : props) {
                    TimeStamp t;
                    if (!(prop instanceof TimeStamp) || !(t = (TimeStamp)prop).getTimeStampName().equals("creation")) continue;
                    found_create = true;
                    break;
                }
                if (!found_create) {
                    TimeStamp t = new TimeStamp(System.currentTimeMillis(), "creation");
                    props.add((Property)t);
                }
                this.edgesDB.put(e, props);
                if (this.isISLink(e)) {
                    this.nodeConnectorsDB.put(e.getHeadNodeConnector(), new HashSet(1));
                    this.nodeConnectorsDB.put(e.getTailNodeConnector(), new HashSet(1));
                }
                log.trace("Edge {}  {}", (Object)e.toString(), (Object)type.name());
                break;
            }
            case REMOVED: {
                this.edgesDB.remove(e);
                this.nodeConnectorsDB.remove(e.getHeadNodeConnector());
                this.nodeConnectorsDB.remove(e.getTailNodeConnector());
                log.trace("Edge {}  {}", (Object)e.toString(), (Object)type.name());
                break;
            }
            case CHANGED: {
                Set oldProps = (Set)this.edgesDB.get(e);
                TimeStamp timeStamp = null;
                if (oldProps != null) {
                    for (Property prop : oldProps) {
                        TimeStamp tsProp;
                        if (!(prop instanceof TimeStamp) || !(tsProp = (TimeStamp)prop).getTimeStampName().equals("creation")) continue;
                        timeStamp = tsProp;
                        break;
                    }
                }
                props = props == null ? new HashSet<Property>() : new HashSet<Property>(props);
                Iterator<Property> i = props.iterator();
                while (i.hasNext()) {
                    TimeStamp t;
                    Property prop;
                    prop = i.next();
                    if (!(prop instanceof TimeStamp) || !(t = (TimeStamp)prop).getTimeStampName().equals("creation")) continue;
                    if (timeStamp == null) break;
                    i.remove();
                    break;
                }
                if (timeStamp != null) {
                    props.add((Property)timeStamp);
                }
                this.edgesDB.put(e, props);
                log.trace("Edge {}  {}", (Object)e.toString(), (Object)type.name());
            }
        }
        return new TopoEdgeUpdate(e, props, type);
    }

    private void doEdgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        ArrayList<TopoEdgeUpdate> teuList = new ArrayList<TopoEdgeUpdate>();
        for (TopoEdgeUpdate teu : topoedgeupdateList) {
            boolean isPending = teu instanceof PendingEdgeUpdate;
            Edge e = teu.getEdge();
            Set p = teu.getProperty();
            UpdateType type = teu.getUpdateType();
            TopoEdgeUpdate update = this.edgeUpdate(e, type, p, isPending);
            if (update == null) continue;
            teuList.add(update);
        }
        if (!teuList.isEmpty()) {
            for (ITopologyManagerAware s : this.topologyManagerAware) {
                try {
                    s.edgeUpdate(teuList);
                }
                catch (Exception exc) {
                    log.error("Exception on edge update:", (Throwable)exc);
                }
            }
        }
    }

    public void edgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        this.updateQ.addAll(topoedgeupdateList);
    }

    private Edge getReverseLinkTuple(TopologyUserLinkConfig link) {
        TopologyUserLinkConfig rLink = new TopologyUserLinkConfig(link.getName(), link.getDstNodeConnector(), link.getSrcNodeConnector());
        return this.getLinkTuple(rLink);
    }

    private Edge getLinkTuple(TopologyUserLinkConfig link) {
        NodeConnector srcNodeConnector = NodeConnector.fromString((String)link.getSrcNodeConnector());
        NodeConnector dstNodeConnector = NodeConnector.fromString((String)link.getDstNodeConnector());
        try {
            return new Edge(srcNodeConnector, dstNodeConnector);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ConcurrentMap<String, TopologyUserLinkConfig> getUserLinks() {
        return new ConcurrentHashMap<String, TopologyUserLinkConfig>(this.userLinksDB);
    }

    @Override
    public Status addUserLink(TopologyUserLinkConfig userLink) {
        if (!userLink.isValid()) {
            return new Status(StatusCode.BADREQUEST, "User link configuration invalid.");
        }
        userLink.setStatus(TopologyUserLinkConfig.STATUS.LINKDOWN);
        for (TopologyUserLinkConfig existingLink : this.userLinksDB.values()) {
            if (!existingLink.equals(userLink)) continue;
            return new Status(StatusCode.CONFLICT, "Link configuration exists");
        }
        if (this.userLinksDB.putIfAbsent(userLink.getName(), userLink) != null) {
            return new Status(StatusCode.CONFLICT, "Link with name : " + userLink.getName() + " already exists. Please use another name");
        }
        Edge linkTuple = this.getLinkTuple(userLink);
        if (linkTuple != null) {
            TopoEdgeUpdate teu;
            if (!this.isProductionLink(linkTuple) && (teu = this.edgeUpdate(linkTuple, UpdateType.ADDED, new HashSet<Property>())) == null) {
                this.userLinksDB.remove(userLink.getName());
                return new Status(StatusCode.NOTFOUND, "Link configuration contains invalid node connector: " + userLink);
            }
            linkTuple = this.getReverseLinkTuple(userLink);
            if (linkTuple != null) {
                userLink.setStatus(TopologyUserLinkConfig.STATUS.SUCCESS);
                if (!this.isProductionLink(linkTuple)) {
                    this.edgeUpdate(linkTuple, UpdateType.ADDED, new HashSet<Property>());
                }
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    @Override
    public Status deleteUserLink(String linkName) {
        Edge linkTuple;
        if (linkName == null) {
            return new Status(StatusCode.BADREQUEST, "User link name cannot be null.");
        }
        TopologyUserLinkConfig link = (TopologyUserLinkConfig)this.userLinksDB.remove(linkName);
        if (link != null && (linkTuple = this.getLinkTuple(link)) != null) {
            if (!this.isProductionLink(linkTuple)) {
                this.edgeUpdate(linkTuple, UpdateType.REMOVED, null);
            }
            if (!this.isProductionLink(linkTuple = this.getReverseLinkTuple(link))) {
                this.edgeUpdate(linkTuple, UpdateType.REMOVED, null);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Topology Manager---\n");
        help.append("\t addUserLink <name> <node connector string> <node connector string>\n");
        help.append("\t deleteUserLink <name>\n");
        help.append("\t printUserLink\n");
        help.append("\t printNodeEdges\n");
        return help.toString();
    }

    public void _printUserLink(CommandInterpreter ci) {
        for (String name : this.userLinksDB.keySet()) {
            TopologyUserLinkConfig linkConfig = (TopologyUserLinkConfig)this.userLinksDB.get(name);
            ci.println((Object)("Name : " + name));
            ci.println((Object)linkConfig);
            ci.println((Object)("Edge " + this.getLinkTuple(linkConfig)));
            ci.println((Object)("Reverse Edge " + this.getReverseLinkTuple(linkConfig)));
        }
    }

    public void _addUserLink(CommandInterpreter ci) {
        String name = ci.nextArgument();
        if (name == null) {
            ci.println((Object)"Please enter a valid Name");
            return;
        }
        String ncStr1 = ci.nextArgument();
        if (ncStr1 == null) {
            ci.println((Object)"Please enter two node connector strings");
            return;
        }
        String ncStr2 = ci.nextArgument();
        if (ncStr2 == null) {
            ci.println((Object)"Please enter second node connector string");
            return;
        }
        NodeConnector nc1 = NodeConnector.fromString((String)ncStr1);
        if (nc1 == null) {
            ci.println((Object)("Invalid input node connector 1 string: " + ncStr1));
            return;
        }
        NodeConnector nc2 = NodeConnector.fromString((String)ncStr2);
        if (nc2 == null) {
            ci.println((Object)("Invalid input node connector 2 string: " + ncStr2));
            return;
        }
        TopologyUserLinkConfig config = new TopologyUserLinkConfig(name, ncStr1, ncStr2);
        ci.println((Object)this.addUserLink(config));
    }

    public void _deleteUserLink(CommandInterpreter ci) {
        String name = ci.nextArgument();
        if (name == null) {
            ci.println((Object)"Please enter a valid Name");
            return;
        }
        this.deleteUserLink(name);
    }

    public void _printNodeEdges(CommandInterpreter ci) {
        Map<Node, Set<Edge>> nodeEdges = this.getNodeEdges();
        if (nodeEdges == null) {
            return;
        }
        Set<Node> nodeSet = nodeEdges.keySet();
        if (nodeSet == null) {
            return;
        }
        ci.println((Object)"        Node                                         Edge");
        for (Node node : nodeSet) {
            Set<Edge> edgeSet = nodeEdges.get(node);
            if (edgeSet == null) continue;
            for (Edge edge : edgeSet) {
                ci.println((Object)(node + "             " + edge));
            }
        }
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    public Status saveConfiguration() {
        return this.saveConfig();
    }

    public void edgeOverUtilized(Edge edge) {
        log.warn("Link Utilization above normal: {}", (Object)edge);
    }

    public void edgeUtilBackToNormal(Edge edge) {
        log.warn("Link Utilization back to normal: {}", (Object)edge);
    }

    private void edgeUpdateClusterWide(Edge e, UpdateType type, Set<Property> props, boolean isLocal) {
        TopoEdgeUpdate upd = new TopoEdgeUpdate(e, props, type);
        upd.setLocal(isLocal);
        this.notifyQ.add(upd);
    }

    public void notifyNode(Node node, UpdateType type, Map<String, Property> propMap) {
    }

    public void notifyNodeConnector(NodeConnector nc, UpdateType type, Map<String, Property> propMap) {
        boolean doFlush = !type.equals((Object)UpdateType.REMOVED);
        this.removePendingEvent(nc, doFlush);
    }

    public void entryCreated(Object key, String cacheName, boolean originLocal) {
        if (cacheName.equals(TOPOEDGESDB)) {
            Edge e = (Edge)key;
            log.trace("Edge {} CREATED isLocal:{}", (Object)e, (Object)originLocal);
            this.edgeUpdateClusterWide(e, UpdateType.ADDED, null, originLocal);
        }
    }

    public void entryUpdated(Object key, Object new_value, String cacheName, boolean originLocal) {
        if (cacheName.equals(TOPOEDGESDB)) {
            Edge e = (Edge)key;
            log.trace("Edge {} UPDATED isLocal:{}", (Object)e, (Object)originLocal);
            Set props = (Set)new_value;
            this.edgeUpdateClusterWide(e, UpdateType.CHANGED, props, originLocal);
        }
    }

    public void entryDeleted(Object key, String cacheName, boolean originLocal) {
        if (cacheName.equals(TOPOEDGESDB)) {
            Edge e = (Edge)key;
            log.trace("Edge {} DELETED isLocal:{}", (Object)e, (Object)originLocal);
            this.edgeUpdateClusterWide(e, UpdateType.REMOVED, null, originLocal);
        }
    }

    @Override
    public List<String> printUserLink() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.userLinksDB.keySet()) {
            TopologyUserLinkConfig linkConfig = (TopologyUserLinkConfig)this.userLinksDB.get(name);
            result.add("Name : " + name);
            result.add(linkConfig.toString());
            result.add("Edge " + this.getLinkTuple(linkConfig));
            result.add("Reverse Edge " + this.getReverseLinkTuple(linkConfig));
        }
        return result;
    }

    @Override
    public List<String> addUserLink(String name, String ncStr1, String ncStr2) {
        ArrayList<String> result = new ArrayList<String>();
        if (name == null) {
            result.add("Please enter a valid Name");
            return result;
        }
        if (ncStr1 == null) {
            result.add("Please enter two node connector strings");
            return result;
        }
        if (ncStr2 == null) {
            result.add("Please enter second node connector string");
            return result;
        }
        NodeConnector nc1 = NodeConnector.fromString((String)ncStr1);
        if (nc1 == null) {
            result.add("Invalid input node connector 1 string: " + ncStr1);
            return result;
        }
        NodeConnector nc2 = NodeConnector.fromString((String)ncStr2);
        if (nc2 == null) {
            result.add("Invalid input node connector 2 string: " + ncStr2);
            return result;
        }
        TopologyUserLinkConfig config = new TopologyUserLinkConfig(name, ncStr1, ncStr2);
        result.add(this.addUserLink(config).toString());
        return result;
    }

    @Override
    public List<String> deleteUserLinkShell(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (name == null) {
            result.add("Please enter a valid Name");
            return result;
        }
        this.deleteUserLink(name);
        return result;
    }

    @Override
    public List<String> printNodeEdges() {
        ArrayList<String> result = new ArrayList<String>();
        Map<Node, Set<Edge>> nodeEdges = this.getNodeEdges();
        if (nodeEdges == null) {
            return result;
        }
        Set<Node> nodeSet = nodeEdges.keySet();
        if (nodeSet == null) {
            return result;
        }
        result.add("        Node                                         Edge");
        for (Node node : nodeSet) {
            Set<Edge> edgeSet = nodeEdges.get(node);
            if (edgeSet == null) continue;
            for (Edge edge : edgeSet) {
                result.add(node + "             " + edge);
            }
        }
        return result;
    }

    void startTest() {
        this.pendingTimer = new Timer("Topology Pending Update Timer");
        this.updateThread = new Thread((Runnable)new UpdateTopology(), "Topology Update");
        this.updateThread.start();
    }

    void stopTest() {
        this.shuttingDown = true;
        this.updateThread.interrupt();
        this.pendingTimer.cancel();
    }

    boolean flushUpdateQueue(long timeout) {
        long cur;
        long limit = System.currentTimeMillis() + timeout;
        do {
            if (this.updateQ.peek() == null) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while ((cur = System.currentTimeMillis()) < limit);
        return false;
    }

    class TopologyNotify
    implements Runnable {
        private final BlockingQueue<TopoEdgeUpdate> notifyQ;
        private TopoEdgeUpdate entry;
        private List<TopoEdgeUpdate> teuList = new ArrayList<TopoEdgeUpdate>();
        private boolean notifyListeners;

        TopologyNotify(BlockingQueue<TopoEdgeUpdate> notifyQ) {
            this.notifyQ = notifyQ;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        log.trace("New run of TopologyNotify");
                        this.notifyListeners = false;
                        this.entry = this.notifyQ.take();
                        while (this.entry != null) {
                            this.teuList.add(this.entry);
                            this.notifyListeners = true;
                            this.entry = (TopoEdgeUpdate)this.notifyQ.poll();
                        }
                        if (this.notifyListeners) {
                            log.trace("Notifier thread, notified a listener");
                            for (ITopologyManagerClusterWideAware s : TopologyManagerImpl.this.topologyManagerClusterWideAware) {
                                try {
                                    s.edgeUpdate(this.teuList);
                                }
                                catch (Exception exc) {
                                    log.error("Exception on edge update:", (Throwable)exc);
                                }
                            }
                        }
                        this.teuList.clear();
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e1) {
                    if (TopologyManagerImpl.this.shuttingDown.booleanValue()) {
                        return;
                    }
                    log.warn("TopologyNotify interrupted {}", (Object)e1.getMessage());
                    continue;
                }
                catch (Exception e2) {
                    log.error("", (Throwable)e2);
                    continue;
                }
                break;
            }
        }
    }

    private class PendingUpdateTask
    extends TimerTask {
        private final Edge edge;
        private final Set<Property> props;
        private final UpdateType type;

        private PendingUpdateTask(Edge e, Set<Property> p, UpdateType t) {
            this.edge = e;
            this.props = p;
            this.type = t;
        }

        private NodeConnector getHeadNodeConnector() {
            return this.edge.getHeadNodeConnector();
        }

        private void flush() {
            log.info("Flush pending topology update: edge {}, type {}", (Object)this.edge, (Object)this.type);
            TopologyManagerImpl.this.updateQ.add(new PendingEdgeUpdate(this.edge, this.props, this.type));
        }

        @Override
        public void run() {
            if (TopologyManagerImpl.this.removePendingEvent(this)) {
                log.warn("Pending topology update timed out: edge{}, type {}", (Object)this.edge, (Object)this.type);
            }
        }
    }

    private class UpdateTopology
    implements Runnable {
        private UpdateTopology() {
        }

        @Override
        public void run() {
            log.trace("Start topology update thread");
            while (!TopologyManagerImpl.this.shuttingDown.booleanValue()) {
                try {
                    ArrayList<TopoEdgeUpdate> list = new ArrayList<TopoEdgeUpdate>();
                    TopoEdgeUpdate teu = (TopoEdgeUpdate)TopologyManagerImpl.this.updateQ.take();
                    while (teu != null) {
                        list.add(teu);
                        teu = (TopoEdgeUpdate)TopologyManagerImpl.this.updateQ.poll();
                    }
                    if (list.isEmpty()) continue;
                    log.trace("Update edges: {}", list);
                    TopologyManagerImpl.this.doEdgeUpdate(list);
                }
                catch (InterruptedException e) {
                    if (TopologyManagerImpl.this.shuttingDown.booleanValue()) break;
                    log.warn("Topology update thread interrupted", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Exception on topology update thread", (Throwable)e);
                }
            }
            log.trace("Exit topology update thread");
        }
    }

    private class PendingEdgeUpdate
    extends TopoEdgeUpdate {
        private PendingEdgeUpdate(Edge e, Set<Property> p, UpdateType t) {
            super(e, p, t);
        }
    }
}

