/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractYangTest;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class RuntimeBeanEntryTest
extends AbstractYangTest {
    public static final String PACKAGE_NAME = "packages.sis";
    public static final String THREADFACTORY_NAMING_MXB_NAME = "threadfactory-naming";
    public static final String THREAD_RUNTIME_BEAN_JAVA_NAME = "ThreadRuntimeMXBean";
    public static final String THREAD_RUNTIME_BEAN_JAVA_PREFIX = "Thread";
    public static final String THREAD_RUNTIME_BEAN_YANG_NAME = "thread";
    public static final String SLEEP_RPC_NAME = "sleep";
    public static final String SLEEP_RPC_OUTPUT = "ThreadState";
    public static final String SLEEP_RPC_INPUT_NAME = "millis";
    public static final String SLEEP_RPC_INPUT_TYPE = "Long";
    private static final Map<IdentitySchemaNode, ServiceInterfaceEntry> identitiesToSIs = new HashMap<IdentitySchemaNode, ServiceInterfaceEntry>();

    @Test
    public void createRuntimeBean() {
        ChoiceCaseNode caseNode = (ChoiceCaseNode)Mockito.mock(ChoiceCaseNode.class);
        ((ChoiceCaseNode)Mockito.doReturn(new HashSet()).when((Object)caseNode)).getChildNodes();
        ((ChoiceCaseNode)Mockito.doReturn(new ArrayList()).when((Object)caseNode)).getUnknownSchemaNodes();
        Map runtimeBeans = RuntimeBeanEntry.extractClassNameToRuntimeBeanMap((String)PACKAGE_NAME, (DataNodeContainer)caseNode, (String)"test-name", (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(this.context)), (String)"test", (Module)this.jmxImplModule, (SchemaContext)this.context);
        Assert.assertEquals((long)1L, (long)runtimeBeans.size());
        RuntimeBeanEntry runtimeMXBean = (RuntimeBeanEntry)runtimeBeans.get("testRuntimeMXBean");
        Assert.assertTrue((boolean)runtimeMXBean.isRoot());
        Assert.assertEquals((Object)"test-name", (Object)runtimeMXBean.getYangName());
    }

    @Test
    public void runtimeBeanRPCTest() {
        Map modulesToSIEs = ServiceInterfaceEntry.create((Module)this.threadsModule, (String)PACKAGE_NAME, identitiesToSIs);
        Assert.assertNotNull((Object)modulesToSIEs);
        Map namesToMBEs = ModuleMXBeanEntry.create((Module)this.threadsJavaModule, (Map)modulesToSIEs, (SchemaContext)this.context, (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(this.context)), (String)PACKAGE_NAME);
        Assert.assertFalse((boolean)namesToMBEs.isEmpty());
        ModuleMXBeanEntry threadfactoryNamingMXBean = (ModuleMXBeanEntry)namesToMBEs.get(THREADFACTORY_NAMING_MXB_NAME);
        Assert.assertNotNull((Object)threadfactoryNamingMXBean);
        Collection runtimeBeanEntries = threadfactoryNamingMXBean.getRuntimeBeans();
        Assert.assertFalse((boolean)runtimeBeanEntries.isEmpty());
        RuntimeBeanEntry threadfactoryRuntimeBeanEntry = this.getRuntimeBeanEntryByJavaName(runtimeBeanEntries, "NamingThreadFactoryRuntimeMXBean");
        Assert.assertNotNull((Object)threadfactoryRuntimeBeanEntry);
        Assert.assertTrue((boolean)threadfactoryRuntimeBeanEntry.isRoot());
        RuntimeBeanEntry runtimeBeanEntry = this.getRuntimeBeanEntryByJavaName(runtimeBeanEntries, THREAD_RUNTIME_BEAN_JAVA_NAME);
        Assert.assertNotNull((Object)runtimeBeanEntry);
        Assert.assertEquals((Object)THREAD_RUNTIME_BEAN_JAVA_PREFIX, (Object)runtimeBeanEntry.getJavaNamePrefix());
        Assert.assertEquals((Object)PACKAGE_NAME, (Object)runtimeBeanEntry.getPackageName());
        Assert.assertEquals((Object)"packages.sis.ThreadRuntimeMXBean", (Object)runtimeBeanEntry.getFullyQualifiedName(runtimeBeanEntry.getJavaNameOfRuntimeMXBean()));
        Assert.assertEquals((Object)THREAD_RUNTIME_BEAN_YANG_NAME, (Object)runtimeBeanEntry.getYangName());
        ArrayList<RuntimeBeanEntry.Rpc> rpcs = new ArrayList<RuntimeBeanEntry.Rpc>(runtimeBeanEntry.getRpcs());
        Assert.assertEquals((long)2L, (long)rpcs.size());
        RuntimeBeanEntry.Rpc rpc = this.getRpcByName(rpcs, SLEEP_RPC_NAME);
        Assert.assertNotNull((Object)rpc);
        Assert.assertEquals((Object)SLEEP_RPC_NAME, (Object)rpc.getYangName());
        Assert.assertTrue((boolean)((JavaAttribute)rpc.getReturnType()).getType().getFullyQualifiedName().endsWith(SLEEP_RPC_OUTPUT));
        List attributes = rpc.getParameters();
        Assert.assertEquals((long)1L, (long)attributes.size());
        JavaAttribute attribute = (JavaAttribute)attributes.get(0);
        Assert.assertEquals((Object)SLEEP_RPC_INPUT_NAME, (Object)attribute.getAttributeYangName());
        Assert.assertEquals((Object)SLEEP_RPC_INPUT_TYPE, (Object)attribute.getType().getName());
        Assert.assertEquals((Object)SLEEP_RPC_INPUT_NAME, (Object)attribute.getLowerCaseCammelCase());
        Assert.assertEquals((Object)"Millis", (Object)attribute.getUpperCaseCammelCase());
        Assert.assertNull((Object)attribute.getNullableDefault());
        Assert.assertNull((Object)attribute.getNullableDescription());
        Assert.assertTrue((boolean)(attribute.getOpenType() instanceof SimpleType));
    }

    private RuntimeBeanEntry getRuntimeBeanEntryByJavaName(Collection<RuntimeBeanEntry> runtimeBeanEntries, String javaName) {
        if (runtimeBeanEntries != null && !runtimeBeanEntries.isEmpty()) {
            for (RuntimeBeanEntry runtimeBeanEntry : runtimeBeanEntries) {
                if (!runtimeBeanEntry.getJavaNameOfRuntimeMXBean().equals(javaName)) continue;
                return runtimeBeanEntry;
            }
        }
        return null;
    }

    private RuntimeBeanEntry.Rpc getRpcByName(List<RuntimeBeanEntry.Rpc> rpcs, String name) {
        if (rpcs != null && !rpcs.isEmpty()) {
            for (RuntimeBeanEntry.Rpc rpc : rpcs) {
                if (!rpc.getName().equals(name)) continue;
                return rpc;
            }
        }
        return null;
    }
}

