/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;

public class RuntimeRegistratorTest {
    protected RuntimeBeanEntry prepareRootRB(List<RuntimeBeanEntry> children) {
        DataNodeContainer nodeContainer = (DataNodeContainer)Mockito.mock(DataNodeContainer.class);
        ((DataNodeContainer)Mockito.doReturn((Object)"DataSchemaNode").when((Object)nodeContainer)).toString();
        return new RuntimeBeanEntry("pa.cka.ge", nodeContainer, "module-name", "ModuleName", true, Optional.absent(), Collections.emptyList(), children, Collections.emptySet());
    }

    protected RuntimeBeanEntry prepareChildRB(List<RuntimeBeanEntry> children, String prefix) {
        DataNodeContainer nodeContainer = (DataNodeContainer)Mockito.mock(DataNodeContainer.class);
        ((DataNodeContainer)Mockito.doReturn((Object)"DataSchemaNode").when((Object)nodeContainer)).toString();
        return new RuntimeBeanEntry("pa.cka.ge", nodeContainer, prefix + "child-name", StringUtils.capitalize((String)prefix) + "ChildName", false, Optional.absent(), Collections.emptyList(), children, Collections.emptySet());
    }

    @Test
    public void testHierarchy() {
        LeafSchemaNode leaf = (LeafSchemaNode)Mockito.mock(LeafSchemaNode.class);
        ((LeafSchemaNode)Mockito.doReturn((Object)new QName(URI.create("urn:x"), "leaf-local-name")).when((Object)leaf)).getQName();
        ((LeafSchemaNode)Mockito.doReturn(Collections.emptyList()).when((Object)leaf)).getUnknownSchemaNodes();
        ((LeafSchemaNode)Mockito.doReturn(null).when((Object)leaf)).getDefault();
        ((LeafSchemaNode)Mockito.doReturn(null).when((Object)leaf)).getDescription();
        TypeProviderWrapper typeProviderWrapper = (TypeProviderWrapper)Mockito.mock(TypeProviderWrapper.class);
        Type mockedType = (Type)Mockito.mock(Type.class);
        ((TypeProviderWrapper)Mockito.doReturn((Object)mockedType).when((Object)typeProviderWrapper)).getType(leaf);
        ((Type)Mockito.doReturn((Object)"java.lang.String").when((Object)mockedType)).getFullyQualifiedName();
    }
}

