/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractYangTest;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;

public class ServiceInterfaceEntryTest
extends AbstractYangTest {
    public static final String PACKAGE_NAME = "packages.sis";
    public static final List<String> expectedSIEFileNames = ServiceInterfaceEntryTest.toFileNames("[EventBusServiceInterface.java, ScheduledThreadPoolServiceInterface.java, ThreadFactoryServiceInterface.java, ThreadPoolServiceInterface.java]");
    private static final URI THREADS_NAMESPACE;
    private static final Date THREADS_REVISION_DATE;
    public static final QName EVENTBUS_QNAME;
    public static final QName THREADFACTORY_QNAME;
    public static final QName THREADPOOL_QNAME;
    public static final QName SCHEDULED_THREADPOOL_QNAME;
    public static final QName SCHEDULED_EXECUTOR_SERVICE_QNAME;
    public static final String SCHEDULED_THREADPOOL_INTERFACE_NAME = "ScheduledThreadPoolServiceInterface";

    public static List<String> toFileNames(String fileNameString) {
        Assert.assertThat((Object)fileNameString.startsWith("["), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fileNameString.endsWith("]"), (Matcher)CoreMatchers.is((Object)true));
        fileNameString = fileNameString.substring(1, fileNameString.length() - 1);
        return Arrays.asList(fileNameString.split(", "));
    }

    @Test
    public void testCreateFromIdentities() {
        HashMap definedIdentities = new HashMap();
        Map namesToSIEntries = ServiceInterfaceEntry.create((Module)this.threadsModule, (String)PACKAGE_NAME, definedIdentities);
        Assert.assertThat((Object)namesToSIEntries.size(), (Matcher)Is.is((Object)expectedSIEFileNames.size()));
        HashSet withNoBaseType = Sets.newHashSet((Object[])new QName[]{EVENTBUS_QNAME, THREADFACTORY_QNAME, THREADPOOL_QNAME, SCHEDULED_EXECUTOR_SERVICE_QNAME});
        HashSet<QName> withBaseType = new HashSet<QName>();
        for (Map.Entry entry : namesToSIEntries.entrySet()) {
            QName qName = (QName)entry.getKey();
            if (withNoBaseType.contains(qName)) {
                ServiceInterfaceEntry sie = (ServiceInterfaceEntry)namesToSIEntries.get(qName);
                Assert.assertNotNull((String)(qName + " not found"), (Object)sie);
                Assert.assertThat((String)(qName + " should have empty base type"), (Object)sie.getBase().isPresent(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)sie.getQName(), (Matcher)Is.is((Object)qName));
                continue;
            }
            withBaseType.add(qName);
        }
        Assert.assertThat(withBaseType, (Matcher)Is.is((Object)Sets.newHashSet((Object[])new QName[]{SCHEDULED_THREADPOOL_QNAME})));
        Assert.assertThat((Object)withBaseType.contains(SCHEDULED_THREADPOOL_QNAME), (Matcher)Is.is((Object)true));
        ServiceInterfaceEntry scheduled = (ServiceInterfaceEntry)namesToSIEntries.get(SCHEDULED_THREADPOOL_QNAME);
        Assert.assertNotNull((Object)scheduled);
        Assert.assertThat((Object)scheduled.getQName(), (Matcher)Is.is((Object)SCHEDULED_THREADPOOL_QNAME));
        ServiceInterfaceEntry threadPool = (ServiceInterfaceEntry)namesToSIEntries.get(THREADPOOL_QNAME);
        Assert.assertNotNull((Object)threadPool);
        Assert.assertThat((String)"scheduled-threadpool should extend threadpool", (Object)scheduled.getBase().get(), (Matcher)Is.is((Object)threadPool));
        Assert.assertThat((Object)scheduled.getExportedOsgiClassName(), (Matcher)Is.is((Object)"org.opendaylight.controller.config.threadpool.ScheduledThreadPool"));
        Assert.assertThat((Object)threadPool.getExportedOsgiClassName(), (Matcher)Is.is((Object)"org.opendaylight.controller.config.threadpool.ThreadPool"));
        String expectedDescription = "An extension of the simple pool of threads able to schedule work to be executed at some point in time.";
        Assert.assertThat((Object)ServiceInterfaceEntryTest.trimInnerSpacesOrNull(scheduled.getNullableDescription()), (Matcher)Is.is((Object)expectedDescription));
        Assert.assertThat((Object)scheduled.getPackageName(), (Matcher)Is.is((Object)PACKAGE_NAME));
        Assert.assertThat((Object)scheduled.getTypeName(), (Matcher)Is.is((Object)SCHEDULED_THREADPOOL_INTERFACE_NAME));
        Assert.assertThat((Object)scheduled.getFullyQualifiedName(), (Matcher)Is.is((Object)"packages.sis.ScheduledThreadPoolServiceInterface"));
    }

    static String trimInnerSpacesOrNull(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\\s{2,}", " ");
    }

    static {
        try {
            THREADS_NAMESPACE = new URI(ConfigConstants.CONFIG_NAMESPACE + ":threads");
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        SimpleDateFormat revisionFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            THREADS_REVISION_DATE = revisionFormat.parse("2013-04-09");
        }
        catch (ParseException e) {
            throw new Error(e);
        }
        EVENTBUS_QNAME = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"eventbus");
        THREADFACTORY_QNAME = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"threadfactory");
        THREADPOOL_QNAME = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"threadpool");
        SCHEDULED_THREADPOOL_QNAME = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"scheduled-threadpool");
        SCHEDULED_EXECUTOR_SERVICE_QNAME = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"scheduled-executor-service");
    }
}

