/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.unknownextension;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntryTest;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.YangModelSearchUtils;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.YangInferencePipeline;

public class UnknownExtensionTest
extends ServiceInterfaceEntryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopOnUnknownLanguageExtension() throws Exception {
        ArrayList yangISs = Lists.newArrayList((Object[])new InputStream[]{this.getClass().getResourceAsStream("test-ifcWithUnknownExtension.yang")});
        yangISs.addAll(UnknownExtensionTest.getConfigApiYangInputStreams());
        try {
            CrossSourceStatementReactor.BuildAction reactor = YangInferencePipeline.RFC6020_REACTOR.newBuild();
            this.context = reactor.buildEffective((List)yangISs);
            this.namesToModules = YangModelSearchUtils.mapModulesByNames(this.context.getModules());
            this.configModule = (Module)this.namesToModules.get("config");
            this.threadsModule = (Module)this.namesToModules.get("config-threads");
            try {
                super.testCreateFromIdentities();
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Unexpected unknown schema node."));
            }
        }
        finally {
            for (InputStream is : yangISs) {
                is.close();
            }
        }
    }
}

