/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.YangModelSearchUtils;
import org.opendaylight.mdsal.binding.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public abstract class AbstractYangTest {
    protected SchemaContext context;
    protected Map<String, Module> namesToModules;
    protected Module configModule;
    protected Module rpcContextModule;
    protected Module threadsModule;
    protected Module threadsJavaModule;
    protected Module bgpListenerJavaModule;
    protected Module ietfInetTypesModule;
    protected Module jmxModule;
    protected Module jmxImplModule;
    protected Module testFilesModule;
    protected Module testFiles1Module;
    public static final String EVENTBUS_MXB_NAME = "eventbus";
    public static final String ASYNC_EVENTBUS_MXB_NAME = "async-eventbus";
    public static final String THREADFACTORY_NAMING_MXB_NAME = "threadfactory-naming";
    public static final String THREADPOOL_DYNAMIC_MXB_NAME = "threadpool-dynamic";
    public static final String THREADPOOL_REGISTRY_IMPL_NAME = "threadpool-registry-impl";
    public static final String BGP_LISTENER_IMPL_MXB_NAME = "bgp-listener-impl";

    @Before
    public void loadYangFiles() throws Exception {
        ArrayList<InputStream> yangISs = new ArrayList<InputStream>();
        yangISs.addAll(AbstractYangTest.getStreams("/test-config-threads.yang", "/test-config-threads-java.yang", "/config-bgp-listener-impl.yang", "/ietf-inet-types.yang", "/config-jmx-it.yang", "/config-jmx-it-impl.yang", "/test-config-files.yang", "/test-config-files1.yang"));
        yangISs.addAll(AbstractYangTest.getConfigApiYangInputStreams());
        this.context = YangParserTestUtils.parseYangStreams(yangISs);
        for (InputStream is : yangISs) {
            is.close();
        }
        this.namesToModules = YangModelSearchUtils.mapModulesByNames(this.context.getModules());
        this.configModule = this.namesToModules.get("config");
        this.rpcContextModule = this.namesToModules.get("config");
        this.threadsModule = this.namesToModules.get("config-threads");
        this.threadsJavaModule = this.namesToModules.get("config-threads-java");
        this.bgpListenerJavaModule = this.namesToModules.get("config-bgp-listener-impl");
        this.ietfInetTypesModule = this.namesToModules.get("ietf-inet-types");
        this.jmxModule = this.namesToModules.get("config-jmx-it");
        this.jmxImplModule = this.namesToModules.get("config-jmx-it-impl");
        this.testFilesModule = this.namesToModules.get("test-config-files");
        this.testFiles1Module = this.namesToModules.get("test-config-files1");
    }

    public static List<InputStream> getConfigApiYangInputStreams() {
        return AbstractYangTest.getStreams("/META-INF/yang/config.yang", "/META-INF/yang/rpc-context.yang");
    }

    public Map<QName, IdentitySchemaNode> mapIdentitiesByQNames(Module module) {
        HashMap<QName, IdentitySchemaNode> result = new HashMap<QName, IdentitySchemaNode>();
        for (IdentitySchemaNode identitySchemaNode : module.getIdentities()) {
            QName qName = identitySchemaNode.getQName();
            Preconditions.checkArgument((!result.containsKey(qName) ? 1 : 0) != 0, (String)"Two identities of %s contain same qname %s", (Object)module, (Object)qName);
            result.put(qName, identitySchemaNode);
        }
        return result;
    }

    protected static List<InputStream> getStreams(String ... paths) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (String path : paths) {
            InputStream is = AbstractYangTest.class.getResourceAsStream(path);
            Assert.assertNotNull((String)(path + " is null"), (Object)is);
            result.add(is);
        }
        return result;
    }

    protected Map<QName, ServiceInterfaceEntry> loadThreadsServiceInterfaceEntries(String packageName) {
        HashMap identitiesToSIs = new HashMap();
        return ServiceInterfaceEntry.create((Module)this.threadsModule, (String)packageName, identitiesToSIs);
    }

    protected Map<String, ModuleMXBeanEntry> loadThreadsJava(Map<QName, ServiceInterfaceEntry> modulesToSIEs, String packageName) {
        Map namesToMBEs = ModuleMXBeanEntry.create((Module)this.threadsJavaModule, modulesToSIEs, (SchemaContext)this.context, (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(this.context)), (String)packageName);
        Assert.assertNotNull((Object)namesToMBEs);
        HashSet expectedMXBeanNames = Sets.newHashSet((Object[])new String[]{EVENTBUS_MXB_NAME, ASYNC_EVENTBUS_MXB_NAME, THREADFACTORY_NAMING_MXB_NAME, THREADPOOL_DYNAMIC_MXB_NAME, THREADPOOL_REGISTRY_IMPL_NAME});
        Assert.assertThat(namesToMBEs.keySet(), (Matcher)CoreMatchers.is((Object)expectedMXBeanNames));
        return namesToMBEs;
    }
}

