/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractYangTest;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.NameConflictException;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.YangModelSearchUtils;
import org.opendaylight.mdsal.binding.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleMXBeanEntryNameConflictTest
extends AbstractYangTest {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleMXBeanEntryNameConflictTest.class);
    public static final String PACKAGE_NAME = "pack2";
    Map<File, String> testedFilesToYangModules = new HashMap<File, String>();
    Map<String, String> testedYangModulesToExpectedConflictingName = new HashMap<String, String>();

    @Ignore
    @Test
    public void testNameConflicts() throws Exception {
        this.prepareSamples();
        this.prepareExceptionAssertions();
        for (Map.Entry<File, String> currentTestEntry : this.testedFilesToYangModules.entrySet()) {
            String moduleName = currentTestEntry.getValue();
            File yangFile = currentTestEntry.getKey();
            Module testedModule = this.loadYangs(yangFile, moduleName);
            try {
                LOG.debug("Testing {}", (Object)yangFile);
                ModuleMXBeanEntry.create((Module)testedModule, new HashMap(), (SchemaContext)this.context, (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(this.context)), (String)PACKAGE_NAME);
                Assert.fail((String)(yangFile.toString() + " did not cause a name conflict and should"));
            }
            catch (NameConflictException e) {
                Assert.assertEquals((Object)this.testedYangModulesToExpectedConflictingName.get(moduleName), (Object)e.getConflictingName());
            }
        }
    }

    private void prepareSamples() {
        File first = new File(this.getClass().getResource("/duplicates/config-test-duplicate-attribute-in-list.yang").getFile());
        File dir = first.getParentFile();
        for (File testYang : dir.listFiles()) {
            String moduleName = ModuleMXBeanEntryNameConflictTest.getYangModuleName(testYang.getName());
            this.testedFilesToYangModules.put(testYang, moduleName);
        }
    }

    private void prepareExceptionAssertions() {
        this.testedYangModulesToExpectedConflictingName.put("config-test-duplicate-attribute", "DtoA");
        this.testedYangModulesToExpectedConflictingName.put("config-test-duplicate-attribute-in-list", "DtoA");
        this.testedYangModulesToExpectedConflictingName.put("config-test-duplicate-attribute-runtime-bean", "DtoA");
        this.testedYangModulesToExpectedConflictingName.put("config-test-generated-attributes-name-conflict", "StateB");
        this.testedYangModulesToExpectedConflictingName.put("config-test-runtime-bean-list-name-conflict", "StateARuntimeMXBean");
        this.testedYangModulesToExpectedConflictingName.put("config-test-runtime-bean-list-name-conflict2", "StateARuntimeMXBean");
        this.testedYangModulesToExpectedConflictingName.put("config-test-runtime-bean-name-conflict", "StateARuntimeMXBean");
        this.testedYangModulesToExpectedConflictingName.put("config-test-runtime-bean-name-conflict2", "StateARuntimeMXBean");
        this.testedYangModulesToExpectedConflictingName.put("config-test-duplicate-attribute-in-runtime-and-mxbean", "port");
    }

    private static String getYangModuleName(String name) {
        boolean startIndex = false;
        int endIndex = name.indexOf(".yang");
        return name.substring(0, endIndex);
    }

    private Module loadYangs(File testedModule, String moduleName) throws Exception {
        ArrayList<InputStream> yangISs = new ArrayList<InputStream>();
        yangISs.addAll(ModuleMXBeanEntryNameConflictTest.getStreams("/ietf-inet-types.yang"));
        yangISs.add(new FileInputStream(testedModule));
        yangISs.addAll(ModuleMXBeanEntryNameConflictTest.getConfigApiYangInputStreams());
        this.context = YangParserTestUtils.parseYangStreams(yangISs);
        for (InputStream is : yangISs) {
            is.close();
        }
        this.namesToModules = YangModelSearchUtils.mapModulesByNames(this.context.getModules());
        this.configModule = (Module)this.namesToModules.get("config");
        Module module = (Module)this.namesToModules.get(moduleName);
        Preconditions.checkNotNull((Object)module, (String)"Cannot get module %s from %s", (Object)moduleName, this.namesToModules.keySet());
        return module;
    }
}

