/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractYangTest;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntryBuilder;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.DependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TypedAttribute;
import org.opendaylight.mdsal.binding.generator.spi.TypeProvider;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class ModuleMXBeanEntryTest
extends AbstractYangTest {
    public static final String PACKAGE_NAME = "pack2";
    protected static final URI THREADS_NAMESPACE;
    protected static final Date THREADS_REVISION_DATE;
    protected Map<QName, ServiceInterfaceEntry> modulesToSIEs;

    @Before
    public void setUp() {
        this.modulesToSIEs = this.loadThreadsServiceInterfaceEntries("packages.sis");
    }

    protected Map<String, ModuleMXBeanEntry> loadThreadsJava() {
        return this.loadThreadsJava(this.modulesToSIEs, PACKAGE_NAME);
    }

    @Test
    public void test_jmxImplModule() {
        HashMap identitiesToSIs = new HashMap();
        Map modulesToSIEs = ServiceInterfaceEntry.create((Module)this.threadsModule, (String)PACKAGE_NAME, identitiesToSIs);
        modulesToSIEs.putAll(ServiceInterfaceEntry.create((Module)this.jmxModule, (String)PACKAGE_NAME, identitiesToSIs));
        Map namesToMBEs = ModuleMXBeanEntry.create((Module)this.jmxImplModule, (Map)modulesToSIEs, (SchemaContext)this.context, (TypeProviderWrapper)new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(this.context)), (String)PACKAGE_NAME);
        Map attributes = ((ModuleMXBeanEntry)namesToMBEs.get("impl-netconf")).getAttributes();
        this.assertCorrectAttributesSize(namesToMBEs, attributes);
        DependencyAttribute threadFactoryAttribute = (DependencyAttribute)attributes.get("thread-factory");
        Assert.assertNotNull((Object)threadFactoryAttribute);
        Assert.assertFalse((boolean)threadFactoryAttribute.getDependency().isMandatory());
        Assert.assertThat((Object)threadFactoryAttribute.getDependency().getSie().getTypeName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"ThreadFactoryServiceInterface"));
        Assert.assertThat((Object)threadFactoryAttribute.getAttributeYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"thread-factory"));
        Assert.assertThat((Object)threadFactoryAttribute.getLowerCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"threadFactory"));
        Assert.assertThat((Object)threadFactoryAttribute.getUpperCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"ThreadFactory"));
        Assert.assertThat((Object)threadFactoryAttribute.getOpenType(), (org.hamcrest.Matcher)CoreMatchers.isA(SimpleType.class));
        Assert.assertNull((Object)threadFactoryAttribute.getNullableDefault());
        Assert.assertNull((Object)threadFactoryAttribute.getNullableDescription());
        Assert.assertThat((Object)threadFactoryAttribute.getType().getName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"ObjectName"));
    }

    private void assertCorrectAttributesSize(Map<String, ModuleMXBeanEntry> namesToMBEs, Map<String, AttributeIfc> attributes) {
        Assert.assertEquals((long)14L, (long)attributes.size());
        Assert.assertEquals((long)1L, (long)namesToMBEs.get("impl-netconf").getRuntimeBeans().size());
        Assert.assertEquals((long)2L, (long)((RuntimeBeanEntry)namesToMBEs.get("impl-netconf").getRuntimeBeans().iterator().next()).getAttributes().size());
        Assert.assertEquals((long)4L, (long)namesToMBEs.get("impl").getAttributes().size());
        Assert.assertEquals((long)1L, (long)namesToMBEs.get("impl").getRuntimeBeans().size());
        Assert.assertEquals((long)1L, (long)((RuntimeBeanEntry)namesToMBEs.get("impl").getRuntimeBeans().iterator().next()).getAttributes().size());
    }

    protected RuntimeBeanEntry findFirstByYangName(Collection<RuntimeBeanEntry> runtimeBeans, String yangName) {
        for (RuntimeBeanEntry rb : runtimeBeans) {
            if (!yangName.equals(rb.getYangName())) continue;
            return rb;
        }
        throw new IllegalArgumentException("Yang name not found:" + yangName + " in " + runtimeBeans);
    }

    protected RuntimeBeanEntry findFirstByNamePrefix(Collection<RuntimeBeanEntry> runtimeBeans, String namePrefix) {
        for (RuntimeBeanEntry rb : runtimeBeans) {
            if (!namePrefix.equals(rb.getJavaNamePrefix())) continue;
            return rb;
        }
        throw new IllegalArgumentException("Name prefix not found:" + namePrefix + " in " + runtimeBeans);
    }

    @Test
    public void testGetWhenConditionMatcher() {
        this.assertMatches("config", "/config:modules/config:module/config:type = 'threadpool-dynamic'");
        this.assertMatches("ns", "/ns:modules/ns:module/ns:type = 'threadpool-dynamic'");
        this.assertMatches("config", "/config:modules/config:module/config:type=\"threadpool-dynamic\"");
    }

    private void assertMatches(String prefix, String input) {
        RevisionAwareXPath whenConstraint = (RevisionAwareXPath)Mockito.mock(RevisionAwareXPath.class);
        ((RevisionAwareXPath)Mockito.doReturn((Object)input).when((Object)whenConstraint)).toString();
        Matcher output = ModuleMXBeanEntryBuilder.getWhenConditionMatcher((String)prefix, (RevisionAwareXPath)whenConstraint);
        Assert.assertTrue((boolean)output.matches());
        Assert.assertEquals((Object)"threadpool-dynamic", (Object)output.group(1));
    }

    @Test
    public void testThreadsJava() {
        Map<String, ModuleMXBeanEntry> namesToMBEs = this.loadThreadsJava();
        ModuleMXBeanEntry dynamicThreadPool = namesToMBEs.get("threadpool-dynamic");
        Map attributes = dynamicThreadPool.getAttributes();
        HashSet longAttribs = Sets.newHashSet((Object[])new String[]{"core-size", "maximum-size"});
        for (String longAttrib : longAttribs) {
            TypedAttribute attribute = (TypedAttribute)attributes.get(longAttrib);
            Assert.assertThat((String)("Failed to check " + longAttrib), (Object)attribute.getType(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Types.typeForClass(Long.class)));
        }
        QName threadfactoryQName = QName.create((URI)THREADS_NAMESPACE, (Date)THREADS_REVISION_DATE, (String)"threadfactory");
        ServiceInterfaceEntry threadFactorySIEntry = this.modulesToSIEs.get(threadfactoryQName);
        Assert.assertNotNull((Object)threadFactorySIEntry);
        boolean expectedMandatory = true;
        TypedAttribute actualThreadFactory = (TypedAttribute)attributes.get("threadfactory");
        DataSchemaNode mockedDataSchemaNode = (DataSchemaNode)Mockito.mock(DataSchemaNode.class);
        ((DataSchemaNode)Mockito.doReturn(Collections.emptyList()).when((Object)mockedDataSchemaNode)).getUnknownSchemaNodes();
        ((DataSchemaNode)Mockito.doReturn((Object)threadfactoryQName).when((Object)mockedDataSchemaNode)).getQName();
        DependencyAttribute expectedDependencyAttribute = new DependencyAttribute(mockedDataSchemaNode, threadFactorySIEntry, true, "threadfactory description");
        Assert.assertThat((Object)actualThreadFactory, (org.hamcrest.Matcher)CoreMatchers.is((Object)expectedDependencyAttribute));
        Assert.assertThat((Object)dynamicThreadPool.getFullyQualifiedName("DynamicThreadPoolModuleMXBean"), (org.hamcrest.Matcher)CoreMatchers.is((Object)"pack2.DynamicThreadPoolModuleMXBean"));
        Assert.assertThat((Object)dynamicThreadPool.getNullableDescription(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"threadpool-dynamic description"));
        Assert.assertThat((Object)dynamicThreadPool.getYangModuleName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"config-threads-java"));
        Assert.assertThat((Object)dynamicThreadPool.getYangModuleLocalname(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"threadpool-dynamic"));
        Collection runtimeBeans = dynamicThreadPool.getRuntimeBeans();
        Assert.assertThat((Object)runtimeBeans.size(), (org.hamcrest.Matcher)CoreMatchers.is((Object)1));
        RuntimeBeanEntry rootRB = this.findFirstByYangName(runtimeBeans, "threadpool-dynamic");
        Assert.assertThat((Object)rootRB.isRoot(), (org.hamcrest.Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)rootRB.getAttributes().size(), (org.hamcrest.Matcher)CoreMatchers.is((Object)1));
        JavaAttribute attribute = (JavaAttribute)rootRB.getAttributes().iterator().next();
        Assert.assertThat((Object)attribute.getAttributeYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"created-sessions"));
        Assert.assertThat((Object)rootRB.getYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"threadpool-dynamic"));
        Assert.assertThat((Object)attribute.getType().getFullyQualifiedName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)Long.class.getName()));
        ModuleMXBeanEntry threadFactoryNaming = namesToMBEs.get("threadfactory-naming");
        Collection runtimeBeans2 = threadFactoryNaming.getRuntimeBeans();
        Assert.assertThat((Object)runtimeBeans2.size(), (org.hamcrest.Matcher)CoreMatchers.is((Object)4));
        RuntimeBeanEntry threadRB = this.findFirstByYangName(runtimeBeans2, "thread");
        Assert.assertNotNull((Object)threadRB);
        Assert.assertFalse((boolean)threadRB.isRoot());
        Assert.assertEquals((Object)"name", (Object)threadRB.getKeyYangName().get());
        Assert.assertEquals((Object)"Name", (Object)threadRB.getKeyJavaName().get());
        Assert.assertThat((Object)threadRB.getAttributes().size(), (org.hamcrest.Matcher)CoreMatchers.is((Object)1));
        AttributeIfc threadNameAttr = (AttributeIfc)threadRB.getAttributes().iterator().next();
        Assert.assertThat((Object)threadNameAttr.getAttributeYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertTrue((boolean)(threadNameAttr instanceof JavaAttribute));
        Assert.assertThat((Object)((JavaAttribute)threadNameAttr).getType().getFullyQualifiedName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)String.class.getName()));
        Assert.assertThat((Object)threadRB.getRpcs().size(), (org.hamcrest.Matcher)CoreMatchers.is((Object)2));
        RuntimeBeanEntry streamRB = this.findFirstByNamePrefix(runtimeBeans2, "ThreadStream");
        Assert.assertNotNull((Object)streamRB);
        Assert.assertFalse((boolean)streamRB.getKeyYangName().isPresent());
        Assert.assertFalse((boolean)streamRB.getKeyJavaName().isPresent());
        Map attributeMap = streamRB.getYangPropertiesToTypesMap();
        Assert.assertEquals((long)4L, (long)attributeMap.size());
        TOAttribute toAttr = (TOAttribute)attributeMap.get("peer");
        Assert.assertNotNull((Object)toAttr);
        Assert.assertThat((Object)toAttr.getAttributeYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"peer"));
        Assert.assertThat((Object)toAttr.getLowerCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"peer"));
        Assert.assertThat((Object)toAttr.getUpperCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"Peer"));
        Assert.assertThat((Object)toAttr.getOpenType(), (org.hamcrest.Matcher)CoreMatchers.isA(CompositeType.class));
        HashSet<String> propsExpected = new HashSet<String>(2);
        propsExpected.add("port");
        propsExpected.add("core-size");
        Assert.assertThat(toAttr.getYangPropertiesToTypesMap().keySet(), (org.hamcrest.Matcher)CoreMatchers.is(propsExpected));
        propsExpected = new HashSet(2);
        propsExpected.add("Port");
        propsExpected.add("CoreSize");
        Assert.assertThat(toAttr.getCapitalizedPropertiesToTypesMap().keySet(), (org.hamcrest.Matcher)CoreMatchers.is(propsExpected));
        propsExpected = new HashSet(2);
        propsExpected.add("port");
        propsExpected.add("coreSize");
        Assert.assertThat(toAttr.getJmxPropertiesToTypesMap().keySet(), (org.hamcrest.Matcher)CoreMatchers.is(propsExpected));
        JavaAttribute timestampAttr = (JavaAttribute)attributeMap.get("timestamp");
        Assert.assertNotNull((Object)timestampAttr);
        JavaAttribute stateAttr = (JavaAttribute)attributeMap.get("state");
        Assert.assertNotNull((Object)stateAttr);
        ListAttribute innerStream = (ListAttribute)attributeMap.get("inner-stream-list");
        Assert.assertNotNull((Object)innerStream);
        Assert.assertThat((Object)innerStream.getAttributeYangName(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"inner-stream-list"));
        Assert.assertThat((Object)innerStream.getLowerCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"innerStreamList"));
        Assert.assertThat((Object)innerStream.getUpperCaseCammelCase(), (org.hamcrest.Matcher)CoreMatchers.is((Object)"InnerStreamList"));
        Assert.assertThat((Object)innerStream.getOpenType(), (org.hamcrest.Matcher)CoreMatchers.isA(ArrayType.class));
        ModuleMXBeanEntry threadPoolRegistry = namesToMBEs.get("threadpool-registry-impl");
        attributes = threadPoolRegistry.getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        AttributeIfc threadpoolsAttr = (AttributeIfc)attributes.get("threadpools");
        Assert.assertNotNull((Object)threadpoolsAttr);
        Assert.assertTrue((boolean)(threadpoolsAttr instanceof ListDependenciesAttribute));
        ListDependenciesAttribute listDependenciesAttribute = (ListDependenciesAttribute)threadpoolsAttr;
    }

    static {
        try {
            THREADS_NAMESPACE = new URI(ConfigConstants.CONFIG_NAMESPACE + ":threads");
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
        SimpleDateFormat revisionFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            THREADS_REVISION_DATE = revisionFormat.parse("2013-04-09");
        }
        catch (ParseException e) {
            throw new Error(e);
        }
    }
}

