/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractYangTest;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public class SchemaContextTest
extends AbstractYangTest {
    IdentitySchemaNode findIdentityByQName(Module module, QName qName) {
        Map<QName, IdentitySchemaNode> mapIdentitiesByQNames = this.mapIdentitiesByQNames(module);
        IdentitySchemaNode found = mapIdentitiesByQNames.get(qName);
        Assert.assertNotNull((Object)found);
        return found;
    }

    @Test
    public void testReadingIdentities_threadsModule() {
        IdentitySchemaNode serviceType = this.findIdentityByQName(this.configModule, ConfigConstants.SERVICE_TYPE_Q_NAME);
        ImmutableMap expectedIdentitiesToBases = ImmutableMap.of((Object)"eventbus", (Object)Optional.absent(), (Object)"threadfactory", (Object)Optional.absent(), (Object)"threadpool", (Object)Optional.absent(), (Object)"scheduled-threadpool", (Object)Optional.absent());
        Assert.assertThat((Object)this.threadsModule.getIdentities().size(), (Matcher)Is.is((Object)expectedIdentitiesToBases.size()));
        this.assertAllIdentitiesAreExpected(this.threadsModule, (Map<String, Optional<QName>>)expectedIdentitiesToBases);
        IdentitySchemaNode eventBusSchemaNode = null;
        for (IdentitySchemaNode id : this.threadsModule.getIdentities()) {
            String localName = id.getQName().getLocalName();
            if (localName.equals("eventbus")) {
                eventBusSchemaNode = id;
            }
            if (localName.equals("scheduled-threadpool")) continue;
            Assert.assertEquals((Object)serviceType, (Object)id.getBaseIdentity());
        }
        Assert.assertNotNull(eventBusSchemaNode);
        List unknownSchemaNodes = eventBusSchemaNode.getUnknownSchemaNodes();
        Assert.assertEquals((long)1L, (long)unknownSchemaNodes.size());
        UnknownSchemaNode usn = (UnknownSchemaNode)unknownSchemaNodes.get(0);
        Assert.assertEquals((Object)"com.google.common.eventbus.EventBus", (Object)usn.getQName().getLocalName());
        Assert.assertEquals((Object)ConfigConstants.JAVA_CLASS_EXTENSION_QNAME, (Object)usn.getNodeType());
    }

    private void assertAllIdentitiesAreExpected(Module module, Map<String, Optional<QName>> expectedIdentitiesToBases) {
        HashMap<String, Optional<QName>> copyOfExpectedNames = new HashMap<String, Optional<QName>>(expectedIdentitiesToBases);
        for (IdentitySchemaNode id : module.getIdentities()) {
            String localName = id.getQName().getLocalName();
            Assert.assertTrue((String)("Unexpected identity " + localName), (boolean)copyOfExpectedNames.containsKey(localName));
            Optional maybeExpectedBaseQName = (Optional)copyOfExpectedNames.remove(localName);
            if (!maybeExpectedBaseQName.isPresent()) continue;
            Assert.assertEquals((String)("Unexpected base identity of " + localName), (Object)maybeExpectedBaseQName.get(), (Object)id.getBaseIdentity().getQName());
        }
        Assert.assertEquals((String)("Expected identities not found " + copyOfExpectedNames), Collections.emptyMap(), copyOfExpectedNames);
    }

    @Test
    public void testReadingIdentities_threadsJavaModule() {
        HashMap<String, Optional<QName>> expectedIdentitiesToBases = new HashMap<String, Optional<QName>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("eventbus", Optional.of((Object)ConfigConstants.MODULE_TYPE_Q_NAME));
                this.put("async-eventbus", Optional.of((Object)ConfigConstants.MODULE_TYPE_Q_NAME));
                this.put("threadfactory-naming", Optional.of((Object)ConfigConstants.MODULE_TYPE_Q_NAME));
                this.put("threadpool-dynamic", Optional.of((Object)ConfigConstants.MODULE_TYPE_Q_NAME));
                this.put("thread-rpc-context", Optional.absent());
                this.put("threadpool-registry-impl", Optional.of((Object)ConfigConstants.MODULE_TYPE_Q_NAME));
            }
        };
        this.assertAllIdentitiesAreExpected(this.threadsJavaModule, (Map<String, Optional<QName>>)expectedIdentitiesToBases);
    }
}

