/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.test.plugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opendaylight.controller.config.yang.test.plugin.Util;

public class ProcessSources
extends AbstractMojo {
    private File directory;
    private static Pattern MULTILINE_COMMENT_PATTERN = Pattern.compile("/\\*.*\\*/", 40);
    private static Pattern UNSUPPORTED_OP_PATTERN = Pattern.compile("^.*TODO.*\n.*throw new java.lang.UnsupportedOperationException.*$", 8);

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] sourceFiles;
        File sourceDirectory;
        if (this.directory == null || !this.directory.exists()) {
            super.getLog().error((CharSequence)"Directory does not exists.");
        }
        if (!(sourceDirectory = new File(this.directory.getPath() + Util.replaceDots(".org.opendaylight.controller.config.yang.test.impl"))).exists()) {
            super.getLog().error((CharSequence)String.format("Source directory does not exists %s", sourceDirectory.getPath()));
        }
        for (File sourceFile : sourceFiles = sourceDirectory.listFiles()) {
            File stubFile;
            String sourceContent;
            if (!sourceFile.getName().endsWith(".java")) continue;
            try {
                sourceContent = Files.toString((File)sourceFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Cannot read %s", sourceFile.getAbsolutePath()), (Throwable)e);
                continue;
            }
            if ((sourceFile.getName().endsWith("Module.java") || sourceFile.getName().endsWith("ModuleFactory.java")) && (stubFile = new File(sourceFile.getPath().replace(".java", "Stub.txt"))).exists()) {
                String stubContent = null;
                try {
                    stubContent = Files.toString((File)stubFile, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)String.format("Cannot read %s", stubFile.getAbsolutePath()), (Throwable)e);
                }
                if (stubContent != null) {
                    sourceContent = ProcessSources.rewriteStub(sourceContent, stubContent);
                }
            }
            sourceContent = ProcessSources.removeCopyrights(sourceContent);
            try {
                Files.write((CharSequence)sourceContent, (File)sourceFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Cannot write %s", sourceFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private static String removeCopyrights(String source) {
        String target = MULTILINE_COMMENT_PATTERN.matcher(source).replaceAll("\n");
        return target;
    }

    private static String rewriteStub(String source, String replaceTODOWith) {
        String target = UNSUPPORTED_OP_PATTERN.matcher(source).replaceFirst(replaceTODOWith);
        return target;
    }
}

