package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * input {
 *   leaf topology-id {
 *     type string;
 *   }
 *   uses pce-path:links;
 *   leaf traffic-class {
 *     type uint8;
 *   }
 *   leaf bandwidth {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>detnet-bandwidth-api/config-e2e-bandwidth/input</i>
 *
 * <p>To create instances of this class use {@link ConfigE2eBandwidthInputBuilder}.
 * @see ConfigE2eBandwidthInputBuilder
 *
 */
public interface ConfigE2eBandwidthInput
    extends
    Links,
    RpcInput,
    Augmentable<ConfigE2eBandwidthInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.ConfigE2eBandwidthInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.ConfigE2eBandwidthInput.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>topologyId</code>, or <code>null</code> if not present
     */
    @Nullable String getTopologyId();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint8</code> <code>trafficClass</code>, or <code>null</code> if not present
     */
    @Nullable Uint8 getTrafficClass();
    
    /**
     * Bits per second.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>bandwidth</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getBandwidth();

}

