package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.links.PathLink;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link DeleteE2eBandwidthInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DeleteE2eBandwidthInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DeleteE2eBandwidthInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DeleteE2eBandwidthInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DeleteE2eBandwidthInputBuilder
 * @see Builder
 *
 */
public class DeleteE2eBandwidthInputBuilder implements Builder<DeleteE2eBandwidthInput> {

    private Uint32 _bandwidth;
    private Uint32 _pathDelay;
    private List<PathLink> _pathLink;
    private Uint32 _pathMetric;
    private String _topologyId;
    private Uint8 _trafficClass;


    Map<Class<? extends Augmentation<DeleteE2eBandwidthInput>>, Augmentation<DeleteE2eBandwidthInput>> augmentation = Collections.emptyMap();

    public DeleteE2eBandwidthInputBuilder() {
    }
    public DeleteE2eBandwidthInputBuilder(org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links arg) {
        this._pathLink = arg.getPathLink();
        this._pathMetric = arg.getPathMetric();
        this._pathDelay = arg.getPathDelay();
    }

    public DeleteE2eBandwidthInputBuilder(DeleteE2eBandwidthInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DeleteE2eBandwidthInput>>, Augmentation<DeleteE2eBandwidthInput>> aug =((AugmentationHolder<DeleteE2eBandwidthInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._bandwidth = base.getBandwidth();
        this._pathDelay = base.getPathDelay();
        this._pathLink = base.getPathLink();
        this._pathMetric = base.getPathMetric();
        this._topologyId = base.getTopologyId();
        this._trafficClass = base.getTrafficClass();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links) {
            this._pathLink = ((org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links)arg).getPathLink();
            this._pathMetric = ((org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links)arg).getPathMetric();
            this._pathDelay = ((org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links)arg).getPathDelay();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.detnet.pce.rev180911.Links]");
    }

    public Uint32 getBandwidth() {
        return _bandwidth;
    }
    
    public Uint32 getPathDelay() {
        return _pathDelay;
    }
    
    public List<PathLink> getPathLink() {
        return _pathLink;
    }
    
    public Uint32 getPathMetric() {
        return _pathMetric;
    }
    
    public String getTopologyId() {
        return _topologyId;
    }
    
    public Uint8 getTrafficClass() {
        return _trafficClass;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DeleteE2eBandwidthInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DeleteE2eBandwidthInputBuilder setBandwidth(final Uint32 value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setBandwidth(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public DeleteE2eBandwidthInputBuilder setBandwidth(final Long value) {
        return setBandwidth(CodeHelpers.compatUint(value));
    }
    
    public DeleteE2eBandwidthInputBuilder setPathDelay(final Uint32 value) {
        this._pathDelay = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setPathDelay(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public DeleteE2eBandwidthInputBuilder setPathDelay(final Long value) {
        return setPathDelay(CodeHelpers.compatUint(value));
    }
    public DeleteE2eBandwidthInputBuilder setPathLink(final List<PathLink> values) {
        this._pathLink = values;
        return this;
    }
    
    
    public DeleteE2eBandwidthInputBuilder setPathMetric(final Uint32 value) {
        this._pathMetric = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setPathMetric(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public DeleteE2eBandwidthInputBuilder setPathMetric(final Long value) {
        return setPathMetric(CodeHelpers.compatUint(value));
    }
    
    public DeleteE2eBandwidthInputBuilder setTopologyId(final String value) {
        this._topologyId = value;
        return this;
    }
    
    public DeleteE2eBandwidthInputBuilder setTrafficClass(final Uint8 value) {
        this._trafficClass = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setTrafficClass(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public DeleteE2eBandwidthInputBuilder setTrafficClass(final Short value) {
        return setTrafficClass(CodeHelpers.compatUint(value));
    }
    
    public DeleteE2eBandwidthInputBuilder addAugmentation(Class<? extends Augmentation<DeleteE2eBandwidthInput>> augmentationType, Augmentation<DeleteE2eBandwidthInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DeleteE2eBandwidthInputBuilder removeAugmentation(Class<? extends Augmentation<DeleteE2eBandwidthInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DeleteE2eBandwidthInput build() {
        return new DeleteE2eBandwidthInputImpl(this);
    }

    private static final class DeleteE2eBandwidthInputImpl
        extends AbstractAugmentable<DeleteE2eBandwidthInput>
        implements DeleteE2eBandwidthInput {
    
        private final Uint32 _bandwidth;
        private final Uint32 _pathDelay;
        private final List<PathLink> _pathLink;
        private final Uint32 _pathMetric;
        private final String _topologyId;
        private final Uint8 _trafficClass;
    
        DeleteE2eBandwidthInputImpl(DeleteE2eBandwidthInputBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._pathDelay = base.getPathDelay();
            this._pathLink = base.getPathLink();
            this._pathMetric = base.getPathMetric();
            this._topologyId = base.getTopologyId();
            this._trafficClass = base.getTrafficClass();
        }
    
        @Override
        public Uint32 getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public Uint32 getPathDelay() {
            return _pathDelay;
        }
        
        @Override
        public List<PathLink> getPathLink() {
            return _pathLink;
        }
        
        @Override
        public Uint32 getPathMetric() {
            return _pathMetric;
        }
        
        @Override
        public String getTopologyId() {
            return _topologyId;
        }
        
        @Override
        public Uint8 getTrafficClass() {
            return _trafficClass;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bandwidth);
            result = prime * result + Objects.hashCode(_pathDelay);
            result = prime * result + Objects.hashCode(_pathLink);
            result = prime * result + Objects.hashCode(_pathMetric);
            result = prime * result + Objects.hashCode(_topologyId);
            result = prime * result + Objects.hashCode(_trafficClass);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DeleteE2eBandwidthInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DeleteE2eBandwidthInput other = (DeleteE2eBandwidthInput)obj;
            if (!Objects.equals(_bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(_pathDelay, other.getPathDelay())) {
                return false;
            }
            if (!Objects.equals(_pathLink, other.getPathLink())) {
                return false;
            }
            if (!Objects.equals(_pathMetric, other.getPathMetric())) {
                return false;
            }
            if (!Objects.equals(_topologyId, other.getTopologyId())) {
                return false;
            }
            if (!Objects.equals(_trafficClass, other.getTrafficClass())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DeleteE2eBandwidthInputImpl otherImpl = (DeleteE2eBandwidthInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DeleteE2eBandwidthInput>>, Augmentation<DeleteE2eBandwidthInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DeleteE2eBandwidthInput");
            CodeHelpers.appendValue(helper, "_bandwidth", _bandwidth);
            CodeHelpers.appendValue(helper, "_pathDelay", _pathDelay);
            CodeHelpers.appendValue(helper, "_pathLink", _pathLink);
            CodeHelpers.appendValue(helper, "_pathMetric", _pathMetric);
            CodeHelpers.appendValue(helper, "_topologyId", _topologyId);
            CodeHelpers.appendValue(helper, "_trafficClass", _trafficClass);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
