package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for implementing the following YANG notifications defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * notification link-bandwidth-change {
 *   container old-link {
 *     uses detnet-topology:detnet-link;
 *   }
 *   leaf new-available-bandwidth {
 *     type uint32;
 *   }
 * }
 * </pre>
 *
 */
public interface DetnetBandwidthApiListener
    extends
    NotificationListener
{




    void onLinkBandwidthChange(LinkBandwidthChange notification);

}

