package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * rpc query-bandwidth-parameter {
 *   input {
 *     leaf node-id {
 *       type string;
 *     }
 *     leaf tp-id {
 *       type string;
 *     }
 *   }
 *   output {
 *     leaf node-id {
 *       type string;
 *     }
 *     uses detnet-service-manager:bandwith-manager-group;
 *   }
 * }
 * rpc config-e2e-bandwidth {
 *   input {
 *     leaf topology-id {
 *       type string;
 *     }
 *     uses pce-path:links;
 *     leaf traffic-class {
 *       type uint8;
 *     }
 *     leaf bandwidth {
 *       type uint32;
 *     }
 *   }
 *   output {
 *     uses detnet-common:configure-result;
 *   }
 * }
 * rpc delete-e2e-bandwidth {
 *   input {
 *     leaf topology-id {
 *       type string;
 *     }
 *     uses pce-path:links;
 *     leaf traffic-class {
 *       type uint8;
 *     }
 *     leaf bandwidth {
 *       type uint32;
 *     }
 *   }
 *   output {
 *     uses detnet-common:configure-result;
 *   }
 * }
 * </pre>
 *
 */
public interface DetnetBandwidthApiService
    extends
    RpcService
{




    @CheckReturnValue
    ListenableFuture<RpcResult<QueryBandwidthParameterOutput>> queryBandwidthParameter(QueryBandwidthParameterInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<ConfigE2eBandwidthOutput>> configE2eBandwidth(ConfigE2eBandwidthInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<DeleteE2eBandwidthOutput>> deleteE2eBandwidth(DeleteE2eBandwidthInput input);

}

