package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.link.bandwidth.change.OldLink;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * notification link-bandwidth-change {
 *   container old-link {
 *     uses detnet-topology:detnet-link;
 *   }
 *   leaf new-available-bandwidth {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>detnet-bandwidth-api/link-bandwidth-change</i>
 *
 * <p>To create instances of this class use {@link LinkBandwidthChangeBuilder}.
 * @see LinkBandwidthChangeBuilder
 *
 */
public interface LinkBandwidthChange
    extends
    DataObject,
    Augmentable<LinkBandwidthChange>,
    Notification
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("link-bandwidth-change");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.LinkBandwidthChange> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.LinkBandwidthChange.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.link.bandwidth.change.OldLink</code> <code>oldLink</code>, or <code>null</code> if not present
     */
    @Nullable OldLink getOldLink();
    
    /**
     * @return <code>org.opendaylight.yangtools.yang.common.Uint32</code> <code>newAvailableBandwidth</code>, or <code>null</code> if not present
     */
    @Nullable Uint32 getNewAvailableBandwidth();

}

