package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * input {
 *   leaf node-id {
 *     type string;
 *   }
 *   leaf tp-id {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>detnet-bandwidth-api/query-bandwidth-parameter/input</i>
 *
 * <p>To create instances of this class use {@link QueryBandwidthParameterInputBuilder}.
 * @see QueryBandwidthParameterInputBuilder
 *
 */
public interface QueryBandwidthParameterInput
    extends
    RpcInput,
    Augmentable<QueryBandwidthParameterInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.QueryBandwidthParameterInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.QueryBandwidthParameterInput.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>nodeId</code>, or <code>null</code> if not present
     */
    @Nullable String getNodeId();
    
    /**
     * @return <code>java.lang.String</code> <code>tpId</code>, or <code>null</code> if not present
     */
    @Nullable String getTpId();

}

