package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>detnet-bandwidth-api</b>
 * <pre>
 * output {
 *   leaf node-id {
 *     type string;
 *   }
 *   uses detnet-service-manager:bandwith-manager-group;
 * }
 * </pre>The schema path to identify an instance is
 * <i>detnet-bandwidth-api/query-bandwidth-parameter/output</i>
 *
 * <p>To create instances of this class use {@link QueryBandwidthParameterOutputBuilder}.
 * @see QueryBandwidthParameterOutputBuilder
 *
 */
public interface QueryBandwidthParameterOutput
    extends
    BandwithManagerGroup,
    RpcOutput,
    Augmentable<QueryBandwidthParameterOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.QueryBandwidthParameterOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.QueryBandwidthParameterOutput.class;
    }
    
    /**
     * @return <code>java.lang.String</code> <code>nodeId</code>, or <code>null</code> if not present
     */
    @Nullable String getNodeId();

}

