package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.bandwith.manager.group.TrafficClasses;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link QueryBandwidthParameterOutputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     QueryBandwidthParameterOutputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new QueryBandwidthParameterOutputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of QueryBandwidthParameterOutputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see QueryBandwidthParameterOutputBuilder
 * @see Builder
 *
 */
public class QueryBandwidthParameterOutputBuilder implements Builder<QueryBandwidthParameterOutput> {

    private String _nodeId;
    private String _tpId;
    private List<TrafficClasses> _trafficClasses;


    Map<Class<? extends Augmentation<QueryBandwidthParameterOutput>>, Augmentation<QueryBandwidthParameterOutput>> augmentation = Collections.emptyMap();

    public QueryBandwidthParameterOutputBuilder() {
    }
    public QueryBandwidthParameterOutputBuilder(org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup arg) {
        this._tpId = arg.getTpId();
        this._trafficClasses = arg.getTrafficClasses();
    }

    public QueryBandwidthParameterOutputBuilder(QueryBandwidthParameterOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<QueryBandwidthParameterOutput>>, Augmentation<QueryBandwidthParameterOutput>> aug =((AugmentationHolder<QueryBandwidthParameterOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nodeId = base.getNodeId();
        this._tpId = base.getTpId();
        this._trafficClasses = base.getTrafficClasses();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup) {
            this._tpId = ((org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup)arg).getTpId();
            this._trafficClasses = ((org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup)arg).getTrafficClasses();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.detnet.service.manager.rev180830.BandwithManagerGroup]");
    }

    public String getNodeId() {
        return _nodeId;
    }
    
    public String getTpId() {
        return _tpId;
    }
    
    public List<TrafficClasses> getTrafficClasses() {
        return _trafficClasses;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<QueryBandwidthParameterOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public QueryBandwidthParameterOutputBuilder setNodeId(final String value) {
        this._nodeId = value;
        return this;
    }
    
    public QueryBandwidthParameterOutputBuilder setTpId(final String value) {
        this._tpId = value;
        return this;
    }
    public QueryBandwidthParameterOutputBuilder setTrafficClasses(final List<TrafficClasses> values) {
        this._trafficClasses = values;
        return this;
    }
    
    
    public QueryBandwidthParameterOutputBuilder addAugmentation(Class<? extends Augmentation<QueryBandwidthParameterOutput>> augmentationType, Augmentation<QueryBandwidthParameterOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public QueryBandwidthParameterOutputBuilder removeAugmentation(Class<? extends Augmentation<QueryBandwidthParameterOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public QueryBandwidthParameterOutput build() {
        return new QueryBandwidthParameterOutputImpl(this);
    }

    private static final class QueryBandwidthParameterOutputImpl
        extends AbstractAugmentable<QueryBandwidthParameterOutput>
        implements QueryBandwidthParameterOutput {
    
        private final String _nodeId;
        private final String _tpId;
        private final List<TrafficClasses> _trafficClasses;
    
        QueryBandwidthParameterOutputImpl(QueryBandwidthParameterOutputBuilder base) {
            super(base.augmentation);
            this._nodeId = base.getNodeId();
            this._tpId = base.getTpId();
            this._trafficClasses = base.getTrafficClasses();
        }
    
        @Override
        public String getNodeId() {
            return _nodeId;
        }
        
        @Override
        public String getTpId() {
            return _tpId;
        }
        
        @Override
        public List<TrafficClasses> getTrafficClasses() {
            return _trafficClasses;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nodeId);
            result = prime * result + Objects.hashCode(_tpId);
            result = prime * result + Objects.hashCode(_trafficClasses);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!QueryBandwidthParameterOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            QueryBandwidthParameterOutput other = (QueryBandwidthParameterOutput)obj;
            if (!Objects.equals(_nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(_tpId, other.getTpId())) {
                return false;
            }
            if (!Objects.equals(_trafficClasses, other.getTrafficClasses())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                QueryBandwidthParameterOutputImpl otherImpl = (QueryBandwidthParameterOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<QueryBandwidthParameterOutput>>, Augmentation<QueryBandwidthParameterOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("QueryBandwidthParameterOutput");
            CodeHelpers.appendValue(helper, "_nodeId", _nodeId);
            CodeHelpers.appendValue(helper, "_tpId", _tpId);
            CodeHelpers.appendValue(helper, "_trafficClasses", _trafficClasses);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
