package org.opendaylight.yang.gen.v1.urn.detnet.bandwidth.api.rev180907.link.bandwidth.change;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.detnet.link.LinkDest;
import org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.detnet.link.LinkSource;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link OldLinkBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     OldLinkBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new OldLinkBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of OldLinkBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see OldLinkBuilder
 * @see Builder
 *
 */
public class OldLinkBuilder implements Builder<OldLink> {

    private Uint32 _availableDetnetBandwidth;
    private Uint32 _linkBandwidth;
    private Uint32 _linkDelay;
    private LinkDest _linkDest;
    private String _linkId;
    private LinkSource _linkSource;
    private Uint32 _loss;
    private Uint32 _maximumReservableBandwidth;
    private Uint32 _metric;
    private Uint32 _reservedDetnetBandwidth;


    Map<Class<? extends Augmentation<OldLink>>, Augmentation<OldLink>> augmentation = Collections.emptyMap();

    public OldLinkBuilder() {
    }
    public OldLinkBuilder(org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink arg) {
        this._linkId = arg.getLinkId();
        this._linkSource = arg.getLinkSource();
        this._linkDest = arg.getLinkDest();
        this._linkDelay = arg.getLinkDelay();
        this._linkBandwidth = arg.getLinkBandwidth();
        this._loss = arg.getLoss();
        this._metric = arg.getMetric();
        this._maximumReservableBandwidth = arg.getMaximumReservableBandwidth();
        this._reservedDetnetBandwidth = arg.getReservedDetnetBandwidth();
        this._availableDetnetBandwidth = arg.getAvailableDetnetBandwidth();
    }

    public OldLinkBuilder(OldLink base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<OldLink>>, Augmentation<OldLink>> aug =((AugmentationHolder<OldLink>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._availableDetnetBandwidth = base.getAvailableDetnetBandwidth();
        this._linkBandwidth = base.getLinkBandwidth();
        this._linkDelay = base.getLinkDelay();
        this._linkDest = base.getLinkDest();
        this._linkId = base.getLinkId();
        this._linkSource = base.getLinkSource();
        this._loss = base.getLoss();
        this._maximumReservableBandwidth = base.getMaximumReservableBandwidth();
        this._metric = base.getMetric();
        this._reservedDetnetBandwidth = base.getReservedDetnetBandwidth();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink) {
            this._linkId = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLinkId();
            this._linkSource = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLinkSource();
            this._linkDest = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLinkDest();
            this._linkDelay = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLinkDelay();
            this._linkBandwidth = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLinkBandwidth();
            this._loss = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getLoss();
            this._metric = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getMetric();
            this._maximumReservableBandwidth = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getMaximumReservableBandwidth();
            this._reservedDetnetBandwidth = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getReservedDetnetBandwidth();
            this._availableDetnetBandwidth = ((org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink)arg).getAvailableDetnetBandwidth();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.detnet.topology.rev180823.DetnetLink]");
    }

    public Uint32 getAvailableDetnetBandwidth() {
        return _availableDetnetBandwidth;
    }
    
    public Uint32 getLinkBandwidth() {
        return _linkBandwidth;
    }
    
    public Uint32 getLinkDelay() {
        return _linkDelay;
    }
    
    public LinkDest getLinkDest() {
        return _linkDest;
    }
    
    public String getLinkId() {
        return _linkId;
    }
    
    public LinkSource getLinkSource() {
        return _linkSource;
    }
    
    public Uint32 getLoss() {
        return _loss;
    }
    
    public Uint32 getMaximumReservableBandwidth() {
        return _maximumReservableBandwidth;
    }
    
    public Uint32 getMetric() {
        return _metric;
    }
    
    public Uint32 getReservedDetnetBandwidth() {
        return _reservedDetnetBandwidth;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<OldLink>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public OldLinkBuilder setAvailableDetnetBandwidth(final Uint32 value) {
        this._availableDetnetBandwidth = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setAvailableDetnetBandwidth(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setAvailableDetnetBandwidth(final Long value) {
        return setAvailableDetnetBandwidth(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setLinkBandwidth(final Uint32 value) {
        this._linkBandwidth = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setLinkBandwidth(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setLinkBandwidth(final Long value) {
        return setLinkBandwidth(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setLinkDelay(final Uint32 value) {
        this._linkDelay = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setLinkDelay(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setLinkDelay(final Long value) {
        return setLinkDelay(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setLinkDest(final LinkDest value) {
        this._linkDest = value;
        return this;
    }
    
    public OldLinkBuilder setLinkId(final String value) {
        this._linkId = value;
        return this;
    }
    
    public OldLinkBuilder setLinkSource(final LinkSource value) {
        this._linkSource = value;
        return this;
    }
    
    public OldLinkBuilder setLoss(final Uint32 value) {
        this._loss = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setLoss(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setLoss(final Long value) {
        return setLoss(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setMaximumReservableBandwidth(final Uint32 value) {
        this._maximumReservableBandwidth = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMaximumReservableBandwidth(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setMaximumReservableBandwidth(final Long value) {
        return setMaximumReservableBandwidth(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setMetric(final Uint32 value) {
        this._metric = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMetric(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setMetric(final Long value) {
        return setMetric(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder setReservedDetnetBandwidth(final Uint32 value) {
        this._reservedDetnetBandwidth = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setReservedDetnetBandwidth(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public OldLinkBuilder setReservedDetnetBandwidth(final Long value) {
        return setReservedDetnetBandwidth(CodeHelpers.compatUint(value));
    }
    
    public OldLinkBuilder addAugmentation(Class<? extends Augmentation<OldLink>> augmentationType, Augmentation<OldLink> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public OldLinkBuilder removeAugmentation(Class<? extends Augmentation<OldLink>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OldLink build() {
        return new OldLinkImpl(this);
    }

    private static final class OldLinkImpl
        extends AbstractAugmentable<OldLink>
        implements OldLink {
    
        private final Uint32 _availableDetnetBandwidth;
        private final Uint32 _linkBandwidth;
        private final Uint32 _linkDelay;
        private final LinkDest _linkDest;
        private final String _linkId;
        private final LinkSource _linkSource;
        private final Uint32 _loss;
        private final Uint32 _maximumReservableBandwidth;
        private final Uint32 _metric;
        private final Uint32 _reservedDetnetBandwidth;
    
        OldLinkImpl(OldLinkBuilder base) {
            super(base.augmentation);
            this._availableDetnetBandwidth = base.getAvailableDetnetBandwidth();
            this._linkBandwidth = base.getLinkBandwidth();
            this._linkDelay = base.getLinkDelay();
            this._linkDest = base.getLinkDest();
            this._linkId = base.getLinkId();
            this._linkSource = base.getLinkSource();
            this._loss = base.getLoss();
            this._maximumReservableBandwidth = base.getMaximumReservableBandwidth();
            this._metric = base.getMetric();
            this._reservedDetnetBandwidth = base.getReservedDetnetBandwidth();
        }
    
        @Override
        public Uint32 getAvailableDetnetBandwidth() {
            return _availableDetnetBandwidth;
        }
        
        @Override
        public Uint32 getLinkBandwidth() {
            return _linkBandwidth;
        }
        
        @Override
        public Uint32 getLinkDelay() {
            return _linkDelay;
        }
        
        @Override
        public LinkDest getLinkDest() {
            return _linkDest;
        }
        
        @Override
        public String getLinkId() {
            return _linkId;
        }
        
        @Override
        public LinkSource getLinkSource() {
            return _linkSource;
        }
        
        @Override
        public Uint32 getLoss() {
            return _loss;
        }
        
        @Override
        public Uint32 getMaximumReservableBandwidth() {
            return _maximumReservableBandwidth;
        }
        
        @Override
        public Uint32 getMetric() {
            return _metric;
        }
        
        @Override
        public Uint32 getReservedDetnetBandwidth() {
            return _reservedDetnetBandwidth;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_availableDetnetBandwidth);
            result = prime * result + Objects.hashCode(_linkBandwidth);
            result = prime * result + Objects.hashCode(_linkDelay);
            result = prime * result + Objects.hashCode(_linkDest);
            result = prime * result + Objects.hashCode(_linkId);
            result = prime * result + Objects.hashCode(_linkSource);
            result = prime * result + Objects.hashCode(_loss);
            result = prime * result + Objects.hashCode(_maximumReservableBandwidth);
            result = prime * result + Objects.hashCode(_metric);
            result = prime * result + Objects.hashCode(_reservedDetnetBandwidth);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OldLink.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            OldLink other = (OldLink)obj;
            if (!Objects.equals(_availableDetnetBandwidth, other.getAvailableDetnetBandwidth())) {
                return false;
            }
            if (!Objects.equals(_linkBandwidth, other.getLinkBandwidth())) {
                return false;
            }
            if (!Objects.equals(_linkDelay, other.getLinkDelay())) {
                return false;
            }
            if (!Objects.equals(_linkDest, other.getLinkDest())) {
                return false;
            }
            if (!Objects.equals(_linkId, other.getLinkId())) {
                return false;
            }
            if (!Objects.equals(_linkSource, other.getLinkSource())) {
                return false;
            }
            if (!Objects.equals(_loss, other.getLoss())) {
                return false;
            }
            if (!Objects.equals(_maximumReservableBandwidth, other.getMaximumReservableBandwidth())) {
                return false;
            }
            if (!Objects.equals(_metric, other.getMetric())) {
                return false;
            }
            if (!Objects.equals(_reservedDetnetBandwidth, other.getReservedDetnetBandwidth())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                OldLinkImpl otherImpl = (OldLinkImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<OldLink>>, Augmentation<OldLink>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("OldLink");
            CodeHelpers.appendValue(helper, "_availableDetnetBandwidth", _availableDetnetBandwidth);
            CodeHelpers.appendValue(helper, "_linkBandwidth", _linkBandwidth);
            CodeHelpers.appendValue(helper, "_linkDelay", _linkDelay);
            CodeHelpers.appendValue(helper, "_linkDest", _linkDest);
            CodeHelpers.appendValue(helper, "_linkId", _linkId);
            CodeHelpers.appendValue(helper, "_linkSource", _linkSource);
            CodeHelpers.appendValue(helper, "_loss", _loss);
            CodeHelpers.appendValue(helper, "_maximumReservableBandwidth", _maximumReservableBandwidth);
            CodeHelpers.appendValue(helper, "_metric", _metric);
            CodeHelpers.appendValue(helper, "_reservedDetnetBandwidth", _reservedDetnetBandwidth);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
