/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.tools.junit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.api.ThreadingPolicy;
import org.jmock.internal.InvocationExpectationBuilder;
import org.jmock.internal.ReturnDefaultValueAction;
import org.jmock.lib.concurrent.Synchroniser;
import org.jmock.lib.legacy.ClassImposteriser;
import org.jmock.syntax.ReceiverClause;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExpectations
extends Expectations {
    protected Mockery context;
    protected boolean showAllExpectations;
    private final Synchroniser synchroniser = new Synchroniser();
    protected static final Logger LOG = LoggerFactory.getLogger(BaseExpectations.class);
    private ReturnDefaultValueAction defaultAction;

    @Before
    public void before() throws Exception {
        this.context = new Mockery(){
            {
                this.setImposteriser(ClassImposteriser.INSTANCE);
                this.setThreadingPolicy((ThreadingPolicy)BaseExpectations.this.synchroniser);
            }
        };
        this.defaultAction = new ReturnDefaultValueAction(ClassImposteriser.INSTANCE);
    }

    @After
    public void after() throws Exception {
        this.context.assertIsSatisfied();
    }

    protected final void ret(Object result) {
        this.will(BaseExpectations.returnValue((Object)result));
    }

    protected final void rethrow(Throwable throwable) {
        this.will(BaseExpectations.throwException((Throwable)throwable));
    }

    protected final void retField(Object container, String fieldName) throws Exception {
        this.will(new ReturnField(container, fieldName));
    }

    protected final void rets(Object ... results) {
        this.will(BaseExpectations.returnValues(results));
    }

    protected final <T> T wany(Class<T> type) {
        return (T)this.with(BaseExpectations.any(type));
    }

    protected final int wanyint() {
        return this.with(BaseExpectations.any(Integer.TYPE));
    }

    protected final long wanylong() {
        return this.with(BaseExpectations.any(Long.TYPE));
    }

    protected final boolean wanybool() {
        return this.with(BaseExpectations.any(Boolean.TYPE));
    }

    protected final <T> T wsame(T instance) {
        return (T)this.with(BaseExpectations.same(instance));
    }

    protected final <T> T weq(T instance) {
        return (T)this.with(BaseExpectations.equal(instance));
    }

    protected final short weq(short instance) {
        return this.with(BaseExpectations.equal((Object)instance));
    }

    protected final int weq(int instance) {
        return this.with(BaseExpectations.equal((Object)instance));
    }

    protected final long weq(long instance) {
        return this.with(BaseExpectations.equal((Object)instance));
    }

    protected final boolean weq(boolean instance) {
        return this.with(BaseExpectations.equal((Object)instance));
    }

    public static Action returnValues(Object ... result) {
        return new ActionSequenceValue(result);
    }

    protected void retMethod(String methodName) {
        this.will(new MethodAction((Object)this, methodName));
    }

    @SafeVarargs
    protected static final <T> Matcher<T[]> contains(final T ... expected) {
        return new BaseMatcher<T[]>(){

            public boolean matches(Object actual) {
                Object[] arr = (Object[])actual;
                if (arr.length != expected.length) {
                    return false;
                }
                for (Object expectedInstance : expected) {
                    boolean found = false;
                    for (int j = 0; j < arr.length && !found; ++j) {
                        found = arr[j] == expectedInstance;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description arg0) {
            }
        };
    }

    @SafeVarargs
    protected static final <T> Matcher<T[]> sameArbitraryArray(final T ... expectedArr) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(T[] actualArr) {
                HashSet<Object> expected = new HashSet<Object>();
                for (Object val : expectedArr) {
                    expected.add(val);
                }
                HashSet actual = new HashSet();
                actual.addAll(Arrays.asList(actualArr));
                return actual.equals(expected);
            }

            public void describeTo(Description description) {
                description.appendText("Same arbitrary array as " + Arrays.toString(expectedArr));
            }
        };
    }

    @SafeVarargs
    protected static final <T> Matcher<T[]> doseNotContain(final T ... forbiddenValues) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(T[] arr) {
                for (Object forbiddenInstance : forbiddenValues) {
                    for (Object element : arr) {
                        if (element != forbiddenInstance) continue;
                        return false;
                    }
                }
                return true;
            }

            public void describeTo(Description description) {
            }
        };
    }

    public final String[] wStrArr(Object ... expected) {
        return (String[])this.with((Matcher)new StringArrayMatcher(expected));
    }

    protected InvocationExpectationBuilder getCurrentBuilder() {
        try {
            return this.currentBuilder();
        }
        catch (IllegalStateException e) {
            LOG.debug("Catched IllegalStateException", (Throwable)e);
            return null;
        }
    }

    private void addCurrentExpectation() {
        this.context.addExpectation(this.currentBuilder().toExpectation((Action)this.defaultAction));
    }

    public ReceiverClause exactly(int count) {
        ReceiverClause ret = super.exactly(count);
        this.addCurrentExpectation();
        return ret;
    }

    public ReceiverClause atLeast(int count) {
        ReceiverClause ret = super.atLeast(count);
        this.addCurrentExpectation();
        return ret;
    }

    public ReceiverClause between(int minCount, int maxCount) {
        ReceiverClause ret = super.between(minCount, maxCount);
        this.addCurrentExpectation();
        return ret;
    }

    public ReceiverClause atMost(int count) {
        ReceiverClause ret = super.atMost(count);
        this.addCurrentExpectation();
        return ret;
    }

    public class StringArrayMatcher
    extends BaseMatcher<String[]> {
        private final Object[] expected;

        private StringArrayMatcher(Object ... expected) {
            this.expected = expected;
        }

        public boolean matches(Object item) {
            if (!(item instanceof String[])) {
                return false;
            }
            String[] actual = (String[])item;
            if (this.expected.length != actual.length) {
                return false;
            }
            for (int i = 0; i < this.expected.length; ++i) {
                if (this.expected[i] == null || this.expected[i].toString().equals(actual[i])) continue;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("String" + Arrays.toString(this.expected));
        }
    }

    public static class ValueSaverAction<T>
    extends BaseMatcher<T>
    implements Action {
        private final String logMatch;
        private final boolean logInvocation;
        public T lastValue;
        public final List<T> values = new ArrayList<T>();

        public ValueSaverAction() {
            this(null, false);
        }

        public ValueSaverAction(String logMatch, boolean logInvocation) {
            this.logMatch = logMatch;
            this.logInvocation = logInvocation;
        }

        public final boolean matches(Object arg) {
            Object value = arg;
            if (!this.validate(value)) {
                return false;
            }
            this.lastValue = this.transformOnMatch(value);
            this.values.add(this.lastValue);
            boolean match = this.match(this.lastValue);
            if (match && this.logMatch != null) {
                LOG.trace("Match: " + this.logMatch + " " + value);
            }
            return match;
        }

        protected T onMatch(T value) {
            return value;
        }

        protected boolean match(T lastValue2) {
            return true;
        }

        protected boolean validate(T value) {
            return true;
        }

        protected T transformOnMatch(T value) {
            return value;
        }

        public void describeTo(Description arg0) {
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.logInvocation) {
                LOG.trace("Invoke: returning " + this.lastValue);
            }
            return this.lastValue;
        }

        public String toString() {
            return "ValueSavers: " + this.values.toString();
        }
    }

    protected static final class ReturnField
    implements Action {
        private final Object container;
        private final Field field;

        public ReturnField(Object container, String fieldName) throws Exception {
            this.container = container;
            this.field = container.getClass().getDeclaredField(fieldName);
            this.field.setAccessible(true);
        }

        public void describeTo(Description description) {
            description.appendText("return " + this.container.getClass().getName() + "." + this.field.getName());
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return this.field.get(this.container);
        }
    }

    private static class ActionSequenceValue
    implements Action {
        private final Object[] values;
        private int i = 0;

        public ActionSequenceValue(Object ... values) {
            this.values = values;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.i < this.values.length) {
                return this.values[this.i++];
            }
            throw new RuntimeException("no morCxtrmExpectationse actions available: " + invocation);
        }

        public void describeTo(Description description) {
            description.appendText(", and then ").appendText(Arrays.toString(this.values));
        }
    }

    private static class MethodAction
    implements Action {
        private Object testInstance;
        private String methodName;
        private Method method;

        public MethodAction(Object testInstance, String methodName) {
            this.testInstance = testInstance;
            this.methodName = methodName;
            this.method = this.findMethod(testInstance.getClass());
            Assert.assertNotNull((String)("Cannot locate '" + methodName + "'"), (Object)this.method);
        }

        private Method findMethod(Class<? extends Object> clazz) {
            if (Object.class.equals(clazz)) {
                return null;
            }
            try {
                return clazz.getMethod(this.methodName, Invocation.class);
            }
            catch (SecurityException e) {
                LOG.debug("Catched SecurityException", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Catched NoSuchMethodException", (Throwable)e);
            }
            return this.findMethod(clazz.getSuperclass());
        }

        public void describeTo(Description arg0) {
            arg0.appendText("running " + this.methodName);
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Exception e = null;
            try {
                return this.method.invoke(this.testInstance, invocation);
            }
            catch (SecurityException se) {
                e = se;
            }
            catch (IllegalAccessException iae) {
                e = iae;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            Assert.fail((String)("Got " + e.getMessage() + " while trying to execute '" + this.methodName + "'"));
            return null;
        }
    }
}

