/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.tools.junit;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.hamcrest.Description;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.junit.Assert;
import org.opendaylight.lispflowmapping.tools.junit.BaseExpectations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTestCase
extends BaseExpectations {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseTestCase.class);

    protected InetAddress asInet(int intValue) {
        try {
            return InetAddress.getByAddress(ByteBuffer.allocate(4).putInt(intValue).array());
        }
        catch (UnknownHostException e) {
            LOG.debug("Unknown host {}", (Object)ByteBuffer.allocate(4).putInt(intValue).array(), (Object)e);
            BaseTestCase.fail("");
            return null;
        }
    }

    public static void fail(String message) {
        Assert.fail((String)message);
    }

    public static void fail() {
        Assert.fail();
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertNotNull((String)message, (Object)object);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull((Object)object);
    }

    public static void assertNull(Object message, Object object) {
        Assert.assertNull((String)message.toString(), (Object)object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull((String)("" + object), (Object)object);
    }

    public static void assertSame(String message, Object expected, Object actual) {
        Assert.assertSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        Assert.assertNotSame((String)message, (Object)unexpected, (Object)actual);
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame((Object)unexpected, (Object)actual);
    }

    protected Object inject(Object testedObject, String memberName, Object member) throws Exception {
        BaseTestCase.assertNotNull(testedObject);
        BaseTestCase.assertNotNull(memberName);
        BaseTestCase.assertNotNull(member);
        Field field = null;
        for (Class<?> cls = testedObject.getClass(); cls != null && field == null; cls = cls.getSuperclass()) {
            field = cls.getDeclaredField(memberName);
        }
        BaseTestCase.assertNotNull("Couldn't find member '" + memberName + "' in " + testedObject.getClass().getSimpleName(), field);
        return this.inject(testedObject, new FieldData(field, member));
    }

    protected Object injectStatic(Class<?> clazz, String memberName, Object member) throws Exception {
        BaseTestCase.assertNotNull(clazz);
        BaseTestCase.assertNotNull(memberName);
        BaseTestCase.assertNotNull(member);
        Field field = null;
        for (Class<?> cls = clazz; cls != null && field == null; cls = cls.getSuperclass()) {
            field = cls.getDeclaredField(memberName);
        }
        BaseTestCase.assertNotNull("Couldn't find member '" + memberName + "' in " + clazz.getSimpleName(), field);
        return this.inject(null, new FieldData(field, member));
    }

    protected Object inject(Object testedObject, FieldData fieldData) {
        BaseTestCase.assertNotNull(fieldData.field);
        Field field = fieldData.field;
        if (fieldData.value != null) {
            try {
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(testedObject, fieldData.value);
                return fieldData.value;
            }
            catch (Exception e) {
                LOG.debug("Caught generic exception", (Throwable)e);
                BaseTestCase.fail(e.getMessage());
            }
        }
        return null;
    }

    protected static ByteBuffer hexToByteBuffer(String hex) {
        String[] hexBytes = hex.split(" ");
        ByteBuffer bb = ByteBuffer.allocate(hexBytes.length);
        for (String hexByte : hexBytes) {
            bb.put((byte)Integer.parseInt(hexByte, 16));
        }
        bb.clear();
        return bb;
    }

    protected static void assertHexEquals(short expected, short actual) {
        Assert.assertEquals((Object)String.format("0x%04X", expected), (Object)String.format("0x%04X", actual));
    }

    protected static void assertHexEquals(byte expected, byte actual) {
        Assert.assertEquals((Object)String.format("0x%02X", expected), (Object)String.format("0x%02X", actual));
    }

    protected abstract class SimpleAction
    implements Action {
        protected SimpleAction() {
        }

        public void describeTo(Description arg0) {
        }

        public abstract Object invoke(Invocation var1) throws Throwable;
    }

    protected static final class FieldData {
        public final Field field;
        public Object value;

        public FieldData(Field field, Object value) {
            BaseTestCase.assertNotNull(field);
            this.field = field;
            this.value = value;
        }
    }
}

