package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping cache-stats {
 *   leaf hits {
 *     type int64;
 *   }
 *   leaf misses {
 *     type int64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/cache-stats</i>
 *
 */
public interface CacheStats
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("cache-stats");

    @Override
    Class<? extends CacheStats> implementedInterface();
    
    /**
     * @return <code>java.lang.Long</code> <code>hits</code>, or <code>null</code> if not present
     */
    @Nullable Long getHits();
    
    /**
     * @return <code>java.lang.Long</code> <code>misses</code>, or <code>null</code> if not present
     */
    @Nullable Long getMisses();

}

