package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping ctrl-msg-stats {
 *   leaf rx-unknown {
 *     type int64;
 *   }
 *   leaf tx-errors {
 *     type int64;
 *   }
 *   list control-message {
 *     ordered-by user;
 *     leaf msg-type {
 *       type lisp-proto:message-type;
 *     }
 *     leaf rx-count {
 *       type int64;
 *     }
 *     leaf tx-count {
 *       type int64;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/ctrl-msg-stats</i>
 *
 */
public interface CtrlMsgStats
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ctrl-msg-stats");

    @Override
    Class<? extends CtrlMsgStats> implementedInterface();
    
    /**
     * @return <code>java.lang.Long</code> <code>rxUnknown</code>, or <code>null</code> if not present
     */
    @Nullable Long getRxUnknown();
    
    /**
     * @return <code>java.lang.Long</code> <code>txErrors</code>, or <code>null</code> if not present
     */
    @Nullable Long getTxErrors();
    
    /**
     * @return <code>java.util.List</code> <code>controlMessage</code>, or <code>null</code> if not present
     */
    @Nullable List<ControlMessage> getControlMessage();
    
    /**
     * @return <code>java.util.List</code> <code>controlMessage</code>, or an empty list if it is not present
     */
    default @NonNull List<ControlMessage> nonnullControlMessage() {
        return CodeHelpers.nonnull(getControlMessage());
    }

}

