package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.MapRegisterCacheStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * output {
 *   container control-message-stats {
 *     uses ctrl-msg-stats;
 *   }
 *   container map-register-cache-stats {
 *     uses cache-stats;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/get-stats/output</i>
 *
 * <p>To create instances of this class use {@link GetStatsOutputBuilder}.
 * @see GetStatsOutputBuilder
 *
 */
public interface GetStatsOutput
    extends
    RpcOutput,
    Augmentable<GetStatsOutput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("output");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.GetStatsOutput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.GetStatsOutput.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats</code> <code>controlMessageStats</code>, or <code>null</code> if not present
     */
    @Nullable ControlMessageStats getControlMessageStats();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.MapRegisterCacheStats</code> <code>mapRegisterCacheStats</code>, or <code>null</code> if not present
     */
    @Nullable MapRegisterCacheStats getMapRegisterCacheStats();

}

