package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.MapRegisterCacheStats;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetStatsOutputBuilder} instances.
 *
 * @see GetStatsOutputBuilder
 *
 */
public class GetStatsOutputBuilder implements Builder<GetStatsOutput> {

    private ControlMessageStats _controlMessageStats;
    private MapRegisterCacheStats _mapRegisterCacheStats;


    Map<Class<? extends Augmentation<GetStatsOutput>>, Augmentation<GetStatsOutput>> augmentation = Collections.emptyMap();

    public GetStatsOutputBuilder() {
    }

    public GetStatsOutputBuilder(GetStatsOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetStatsOutput>>, Augmentation<GetStatsOutput>> aug =((AugmentationHolder<GetStatsOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._controlMessageStats = base.getControlMessageStats();
        this._mapRegisterCacheStats = base.getMapRegisterCacheStats();
    }


    public ControlMessageStats getControlMessageStats() {
        return _controlMessageStats;
    }
    
    public MapRegisterCacheStats getMapRegisterCacheStats() {
        return _mapRegisterCacheStats;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetStatsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetStatsOutputBuilder setControlMessageStats(final ControlMessageStats value) {
        this._controlMessageStats = value;
        return this;
    }
    
    public GetStatsOutputBuilder setMapRegisterCacheStats(final MapRegisterCacheStats value) {
        this._mapRegisterCacheStats = value;
        return this;
    }
    
    public GetStatsOutputBuilder addAugmentation(Class<? extends Augmentation<GetStatsOutput>> augmentationType, Augmentation<GetStatsOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetStatsOutputBuilder removeAugmentation(Class<? extends Augmentation<GetStatsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetStatsOutput build() {
        return new GetStatsOutputImpl(this);
    }

    private static final class GetStatsOutputImpl
        extends AbstractAugmentable<GetStatsOutput>
        implements GetStatsOutput {
    
        private final ControlMessageStats _controlMessageStats;
        private final MapRegisterCacheStats _mapRegisterCacheStats;
    
        GetStatsOutputImpl(GetStatsOutputBuilder base) {
            super(base.augmentation);
            this._controlMessageStats = base.getControlMessageStats();
            this._mapRegisterCacheStats = base.getMapRegisterCacheStats();
        }
    
        @Override
        public ControlMessageStats getControlMessageStats() {
            return _controlMessageStats;
        }
        
        @Override
        public MapRegisterCacheStats getMapRegisterCacheStats() {
            return _mapRegisterCacheStats;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_controlMessageStats);
            result = prime * result + Objects.hashCode(_mapRegisterCacheStats);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetStatsOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetStatsOutput other = (GetStatsOutput)obj;
            if (!Objects.equals(_controlMessageStats, other.getControlMessageStats())) {
                return false;
            }
            if (!Objects.equals(_mapRegisterCacheStats, other.getMapRegisterCacheStats())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetStatsOutputImpl otherImpl = (GetStatsOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetStatsOutput>>, Augmentation<GetStatsOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetStatsOutput");
            CodeHelpers.appendValue(helper, "_controlMessageStats", _controlMessageStats);
            CodeHelpers.appendValue(helper, "_mapRegisterCacheStats", _mapRegisterCacheStats);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
