package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>odl-lisp-sb</b>
 * <pre>
 * rpc send-map-reply {
 *   input {
 *     uses lisp-proto:MapReplyMessage;
 *   }
 *   output;
 * }
 * rpc send-map-request {
 *   input {
 *     uses lisp-proto:MapRequestMessage;
 *   }
 *   output;
 * }
 * rpc reset-stats {
 *   input;
 *   output;
 * }
 * rpc send-map-notify {
 *   input {
 *     uses lisp-proto:MapNotifyMessage;
 *   }
 *   output;
 * }
 * rpc get-stats {
 *   output {
 *     container control-message-stats {
 *       uses ctrl-msg-stats;
 *     }
 *     container map-register-cache-stats {
 *       uses cache-stats;
 *     }
 *   }
 *   input;
 * }
 * rpc send-map-register {
 *   input {
 *     uses lisp-proto:MapRegisterMessage;
 *   }
 *   output;
 * }
 * </pre>
 *
 */
public interface OdlLispSbService
    extends
    RpcService
{




    @CheckReturnValue
    ListenableFuture<RpcResult<SendMapReplyOutput>> sendMapReply(SendMapReplyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<SendMapRequestOutput>> sendMapRequest(SendMapRequestInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<ResetStatsOutput>> resetStats(ResetStatsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<SendMapNotifyOutput>> sendMapNotify(SendMapNotifyInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<GetStatsOutput>> getStats(GetStatsInput input);
    
    @CheckReturnValue
    ListenableFuture<RpcResult<SendMapRegisterOutput>> sendMapRegister(SendMapRegisterInput input);

}

