package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ResetStatsOutputBuilder} instances.
 *
 * @see ResetStatsOutputBuilder
 *
 */
public class ResetStatsOutputBuilder implements Builder<ResetStatsOutput> {



    Map<Class<? extends Augmentation<ResetStatsOutput>>, Augmentation<ResetStatsOutput>> augmentation = Collections.emptyMap();

    public ResetStatsOutputBuilder() {
    }

    public ResetStatsOutputBuilder(ResetStatsOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ResetStatsOutput>>, Augmentation<ResetStatsOutput>> aug =((AugmentationHolder<ResetStatsOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ResetStatsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ResetStatsOutputBuilder addAugmentation(Class<? extends Augmentation<ResetStatsOutput>> augmentationType, Augmentation<ResetStatsOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ResetStatsOutputBuilder removeAugmentation(Class<? extends Augmentation<ResetStatsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ResetStatsOutput build() {
        return new ResetStatsOutputImpl(this);
    }

    private static final class ResetStatsOutputImpl
        extends AbstractAugmentable<ResetStatsOutput>
        implements ResetStatsOutput {
    
    
        ResetStatsOutputImpl(ResetStatsOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ResetStatsOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ResetStatsOutput other = (ResetStatsOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ResetStatsOutputImpl otherImpl = (ResetStatsOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ResetStatsOutput>>, Augmentation<ResetStatsOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ResetStatsOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
