package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapnotifymessage.MapNotify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapNotifyInputBuilder} instances.
 *
 * @see SendMapNotifyInputBuilder
 *
 */
public class SendMapNotifyInputBuilder implements Builder<SendMapNotifyInput> {

    private MapNotify _mapNotify;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapNotifyInput>>, Augmentation<SendMapNotifyInput>> augmentation = Collections.emptyMap();

    public SendMapNotifyInputBuilder() {
    }
    public SendMapNotifyInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapNotifyMessage arg) {
        this._mapNotify = arg.getMapNotify();
        this._transportAddress = arg.getTransportAddress();
    }
    public SendMapNotifyInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }

    public SendMapNotifyInputBuilder(SendMapNotifyInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SendMapNotifyInput>>, Augmentation<SendMapNotifyInput>> aug =((AugmentationHolder<SendMapNotifyInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mapNotify = base.getMapNotify();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapNotifyMessage</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapNotifyMessage) {
            this._mapNotify = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapNotifyMessage)arg).getMapNotify();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress) {
            this._transportAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress)arg).getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapNotifyMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }

    public MapNotify getMapNotify() {
        return _mapNotify;
    }
    
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapNotifyInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SendMapNotifyInputBuilder setMapNotify(final MapNotify value) {
        this._mapNotify = value;
        return this;
    }
    
    public SendMapNotifyInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    public SendMapNotifyInputBuilder addAugmentation(Class<? extends Augmentation<SendMapNotifyInput>> augmentationType, Augmentation<SendMapNotifyInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SendMapNotifyInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapNotifyInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SendMapNotifyInput build() {
        return new SendMapNotifyInputImpl(this);
    }

    private static final class SendMapNotifyInputImpl
        extends AbstractAugmentable<SendMapNotifyInput>
        implements SendMapNotifyInput {
    
        private final MapNotify _mapNotify;
        private final TransportAddress _transportAddress;
    
        SendMapNotifyInputImpl(SendMapNotifyInputBuilder base) {
            super(base.augmentation);
            this._mapNotify = base.getMapNotify();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapNotify getMapNotify() {
            return _mapNotify;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mapNotify);
            result = prime * result + Objects.hashCode(_transportAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SendMapNotifyInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SendMapNotifyInput other = (SendMapNotifyInput)obj;
            if (!Objects.equals(_mapNotify, other.getMapNotify())) {
                return false;
            }
            if (!Objects.equals(_transportAddress, other.getTransportAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SendMapNotifyInputImpl otherImpl = (SendMapNotifyInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SendMapNotifyInput>>, Augmentation<SendMapNotifyInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SendMapNotifyInput");
            CodeHelpers.appendValue(helper, "_mapNotify", _mapNotify);
            CodeHelpers.appendValue(helper, "_transportAddress", _transportAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
