package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapregistermessage.MapRegister;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapRegisterInputBuilder} instances.
 *
 * @see SendMapRegisterInputBuilder
 *
 */
public class SendMapRegisterInputBuilder implements Builder<SendMapRegisterInput> {

    private MapRegister _mapRegister;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapRegisterInput>>, Augmentation<SendMapRegisterInput>> augmentation = Collections.emptyMap();

    public SendMapRegisterInputBuilder() {
    }
    public SendMapRegisterInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRegisterMessage arg) {
        this._mapRegister = arg.getMapRegister();
        this._transportAddress = arg.getTransportAddress();
    }
    public SendMapRegisterInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }

    public SendMapRegisterInputBuilder(SendMapRegisterInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SendMapRegisterInput>>, Augmentation<SendMapRegisterInput>> aug =((AugmentationHolder<SendMapRegisterInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mapRegister = base.getMapRegister();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRegisterMessage</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRegisterMessage) {
            this._mapRegister = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRegisterMessage)arg).getMapRegister();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress) {
            this._transportAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress)arg).getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRegisterMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }

    public MapRegister getMapRegister() {
        return _mapRegister;
    }
    
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapRegisterInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SendMapRegisterInputBuilder setMapRegister(final MapRegister value) {
        this._mapRegister = value;
        return this;
    }
    
    public SendMapRegisterInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    public SendMapRegisterInputBuilder addAugmentation(Class<? extends Augmentation<SendMapRegisterInput>> augmentationType, Augmentation<SendMapRegisterInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SendMapRegisterInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapRegisterInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SendMapRegisterInput build() {
        return new SendMapRegisterInputImpl(this);
    }

    private static final class SendMapRegisterInputImpl
        extends AbstractAugmentable<SendMapRegisterInput>
        implements SendMapRegisterInput {
    
        private final MapRegister _mapRegister;
        private final TransportAddress _transportAddress;
    
        SendMapRegisterInputImpl(SendMapRegisterInputBuilder base) {
            super(base.augmentation);
            this._mapRegister = base.getMapRegister();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapRegister getMapRegister() {
            return _mapRegister;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mapRegister);
            result = prime * result + Objects.hashCode(_transportAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SendMapRegisterInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SendMapRegisterInput other = (SendMapRegisterInput)obj;
            if (!Objects.equals(_mapRegister, other.getMapRegister())) {
                return false;
            }
            if (!Objects.equals(_transportAddress, other.getTransportAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SendMapRegisterInputImpl otherImpl = (SendMapRegisterInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SendMapRegisterInput>>, Augmentation<SendMapRegisterInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SendMapRegisterInput");
            CodeHelpers.appendValue(helper, "_mapRegister", _mapRegister);
            CodeHelpers.appendValue(helper, "_transportAddress", _transportAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
