package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapreplymessage.MapReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapReplyInputBuilder} instances.
 *
 * @see SendMapReplyInputBuilder
 *
 */
public class SendMapReplyInputBuilder implements Builder<SendMapReplyInput> {

    private MapReply _mapReply;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapReplyInput>>, Augmentation<SendMapReplyInput>> augmentation = Collections.emptyMap();

    public SendMapReplyInputBuilder() {
    }
    public SendMapReplyInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage arg) {
        this._mapReply = arg.getMapReply();
        this._transportAddress = arg.getTransportAddress();
    }
    public SendMapReplyInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }

    public SendMapReplyInputBuilder(SendMapReplyInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SendMapReplyInput>>, Augmentation<SendMapReplyInput>> aug =((AugmentationHolder<SendMapReplyInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mapReply = base.getMapReply();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage) {
            this._mapReply = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage)arg).getMapReply();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress) {
            this._transportAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress)arg).getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapReplyMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }

    public MapReply getMapReply() {
        return _mapReply;
    }
    
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapReplyInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SendMapReplyInputBuilder setMapReply(final MapReply value) {
        this._mapReply = value;
        return this;
    }
    
    public SendMapReplyInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    public SendMapReplyInputBuilder addAugmentation(Class<? extends Augmentation<SendMapReplyInput>> augmentationType, Augmentation<SendMapReplyInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SendMapReplyInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapReplyInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SendMapReplyInput build() {
        return new SendMapReplyInputImpl(this);
    }

    private static final class SendMapReplyInputImpl
        extends AbstractAugmentable<SendMapReplyInput>
        implements SendMapReplyInput {
    
        private final MapReply _mapReply;
        private final TransportAddress _transportAddress;
    
        SendMapReplyInputImpl(SendMapReplyInputBuilder base) {
            super(base.augmentation);
            this._mapReply = base.getMapReply();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapReply getMapReply() {
            return _mapReply;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mapReply);
            result = prime * result + Objects.hashCode(_transportAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SendMapReplyInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SendMapReplyInput other = (SendMapReplyInput)obj;
            if (!Objects.equals(_mapReply, other.getMapReply())) {
                return false;
            }
            if (!Objects.equals(_transportAddress, other.getTransportAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SendMapReplyInputImpl otherImpl = (SendMapReplyInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SendMapReplyInput>>, Augmentation<SendMapReplyInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SendMapReplyInput");
            CodeHelpers.appendValue(helper, "_mapReply", _mapReply);
            CodeHelpers.appendValue(helper, "_transportAddress", _transportAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
