package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.maprequestmessage.MapRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.transport.address.TransportAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SendMapRequestInputBuilder} instances.
 *
 * @see SendMapRequestInputBuilder
 *
 */
public class SendMapRequestInputBuilder implements Builder<SendMapRequestInput> {

    private MapRequest _mapRequest;
    private TransportAddress _transportAddress;


    Map<Class<? extends Augmentation<SendMapRequestInput>>, Augmentation<SendMapRequestInput>> augmentation = Collections.emptyMap();

    public SendMapRequestInputBuilder() {
    }
    public SendMapRequestInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage arg) {
        this._mapRequest = arg.getMapRequest();
        this._transportAddress = arg.getTransportAddress();
    }
    public SendMapRequestInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress arg) {
        this._transportAddress = arg.getTransportAddress();
    }

    public SendMapRequestInputBuilder(SendMapRequestInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SendMapRequestInput>>, Augmentation<SendMapRequestInput>> aug =((AugmentationHolder<SendMapRequestInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mapRequest = base.getMapRequest();
        this._transportAddress = base.getTransportAddress();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage) {
            this._mapRequest = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage)arg).getMapRequest();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress) {
            this._transportAddress = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress)arg).getTransportAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MapRequestMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.TransportAddress]");
    }

    public MapRequest getMapRequest() {
        return _mapRequest;
    }
    
    public TransportAddress getTransportAddress() {
        return _transportAddress;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SendMapRequestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SendMapRequestInputBuilder setMapRequest(final MapRequest value) {
        this._mapRequest = value;
        return this;
    }
    
    public SendMapRequestInputBuilder setTransportAddress(final TransportAddress value) {
        this._transportAddress = value;
        return this;
    }
    
    public SendMapRequestInputBuilder addAugmentation(Class<? extends Augmentation<SendMapRequestInput>> augmentationType, Augmentation<SendMapRequestInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SendMapRequestInputBuilder removeAugmentation(Class<? extends Augmentation<SendMapRequestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SendMapRequestInput build() {
        return new SendMapRequestInputImpl(this);
    }

    private static final class SendMapRequestInputImpl
        extends AbstractAugmentable<SendMapRequestInput>
        implements SendMapRequestInput {
    
        private final MapRequest _mapRequest;
        private final TransportAddress _transportAddress;
    
        SendMapRequestInputImpl(SendMapRequestInputBuilder base) {
            super(base.augmentation);
            this._mapRequest = base.getMapRequest();
            this._transportAddress = base.getTransportAddress();
        }
    
        @Override
        public MapRequest getMapRequest() {
            return _mapRequest;
        }
        
        @Override
        public TransportAddress getTransportAddress() {
            return _transportAddress;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mapRequest);
            result = prime * result + Objects.hashCode(_transportAddress);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SendMapRequestInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SendMapRequestInput other = (SendMapRequestInput)obj;
            if (!Objects.equals(_mapRequest, other.getMapRequest())) {
                return false;
            }
            if (!Objects.equals(_transportAddress, other.getTransportAddress())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SendMapRequestInputImpl otherImpl = (SendMapRequestInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SendMapRequestInput>>, Augmentation<SendMapRequestInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SendMapRequestInput");
            CodeHelpers.appendValue(helper, "_mapRequest", _mapRequest);
            CodeHelpers.appendValue(helper, "_transportAddress", _transportAddress);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
