package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;
import java.lang.Class;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * list control-message {
 *   ordered-by user;
 *   leaf msg-type {
 *     type lisp-proto:message-type;
 *   }
 *   leaf rx-count {
 *     type int64;
 *   }
 *   leaf tx-count {
 *     type int64;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/ctrl-msg-stats/control-message</i>
 *
 * <p>To create instances of this class use {@link ControlMessageBuilder}.
 * @see ControlMessageBuilder
 *
 *
 */
public interface ControlMessage
    extends
    ChildOf<CtrlMsgStats>,
    Augmentable<ControlMessage>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("control-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType</code> <code>msgType</code>, or <code>null</code> if not present
     */
    @Nullable MessageType getMsgType();
    
    /**
     * @return <code>java.lang.Long</code> <code>rxCount</code>, or <code>null</code> if not present
     */
    @Nullable Long getRxCount();
    
    /**
     * @return <code>java.lang.Long</code> <code>txCount</code>, or <code>null</code> if not present
     */
    @Nullable Long getTxCount();

}

