package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ControlMessageBuilder} instances.
 *
 * @see ControlMessageBuilder
 *
 */
public class ControlMessageBuilder implements Builder<ControlMessage> {

    private MessageType _msgType;
    private Long _rxCount;
    private Long _txCount;


    Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> augmentation = Collections.emptyMap();

    public ControlMessageBuilder() {
    }

    public ControlMessageBuilder(ControlMessage base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> aug =((AugmentationHolder<ControlMessage>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._msgType = base.getMsgType();
        this._rxCount = base.getRxCount();
        this._txCount = base.getTxCount();
    }


    public MessageType getMsgType() {
        return _msgType;
    }
    
    public Long getRxCount() {
        return _rxCount;
    }
    
    public Long getTxCount() {
        return _txCount;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ControlMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ControlMessageBuilder setMsgType(final MessageType value) {
        this._msgType = value;
        return this;
    }
    
    public ControlMessageBuilder setRxCount(final Long value) {
        this._rxCount = value;
        return this;
    }
    
    public ControlMessageBuilder setTxCount(final Long value) {
        this._txCount = value;
        return this;
    }
    
    public ControlMessageBuilder addAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType, Augmentation<ControlMessage> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ControlMessageBuilder removeAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ControlMessage build() {
        return new ControlMessageImpl(this);
    }

    private static final class ControlMessageImpl
        extends AbstractAugmentable<ControlMessage>
        implements ControlMessage {
    
        private final MessageType _msgType;
        private final Long _rxCount;
        private final Long _txCount;
    
        ControlMessageImpl(ControlMessageBuilder base) {
            super(base.augmentation);
            this._msgType = base.getMsgType();
            this._rxCount = base.getRxCount();
            this._txCount = base.getTxCount();
        }
    
        @Override
        public MessageType getMsgType() {
            return _msgType;
        }
        
        @Override
        public Long getRxCount() {
            return _rxCount;
        }
        
        @Override
        public Long getTxCount() {
            return _txCount;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_msgType);
            result = prime * result + Objects.hashCode(_rxCount);
            result = prime * result + Objects.hashCode(_txCount);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ControlMessage.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ControlMessage other = (ControlMessage)obj;
            if (!Objects.equals(_msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(_rxCount, other.getRxCount())) {
                return false;
            }
            if (!Objects.equals(_txCount, other.getTxCount())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ControlMessageImpl otherImpl = (ControlMessageImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ControlMessage");
            CodeHelpers.appendValue(helper, "_msgType", _msgType);
            CodeHelpers.appendValue(helper, "_rxCount", _rxCount);
            CodeHelpers.appendValue(helper, "_txCount", _txCount);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
