package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ControlMessageStatsBuilder} instances.
 *
 * @see ControlMessageStatsBuilder
 *
 */
public class ControlMessageStatsBuilder implements Builder<ControlMessageStats> {

    private List<ControlMessage> _controlMessage;
    private Long _rxUnknown;
    private Long _txErrors;


    Map<Class<? extends Augmentation<ControlMessageStats>>, Augmentation<ControlMessageStats>> augmentation = Collections.emptyMap();

    public ControlMessageStatsBuilder() {
    }
    public ControlMessageStatsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats arg) {
        this._rxUnknown = arg.getRxUnknown();
        this._txErrors = arg.getTxErrors();
        this._controlMessage = arg.getControlMessage();
    }

    public ControlMessageStatsBuilder(ControlMessageStats base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ControlMessageStats>>, Augmentation<ControlMessageStats>> aug =((AugmentationHolder<ControlMessageStats>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._controlMessage = base.getControlMessage();
        this._rxUnknown = base.getRxUnknown();
        this._txErrors = base.getTxErrors();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats) {
            this._rxUnknown = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getRxUnknown();
            this._txErrors = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getTxErrors();
            this._controlMessage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getControlMessage();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats]");
    }

    public List<ControlMessage> getControlMessage() {
        return _controlMessage;
    }
    
    public Long getRxUnknown() {
        return _rxUnknown;
    }
    
    public Long getTxErrors() {
        return _txErrors;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ControlMessageStats>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ControlMessageStatsBuilder setControlMessage(final List<ControlMessage> values) {
        this._controlMessage = values;
        return this;
    }
    
    
    public ControlMessageStatsBuilder setRxUnknown(final Long value) {
        this._rxUnknown = value;
        return this;
    }
    
    public ControlMessageStatsBuilder setTxErrors(final Long value) {
        this._txErrors = value;
        return this;
    }
    
    public ControlMessageStatsBuilder addAugmentation(Class<? extends Augmentation<ControlMessageStats>> augmentationType, Augmentation<ControlMessageStats> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ControlMessageStatsBuilder removeAugmentation(Class<? extends Augmentation<ControlMessageStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ControlMessageStats build() {
        return new ControlMessageStatsImpl(this);
    }

    private static final class ControlMessageStatsImpl
        extends AbstractAugmentable<ControlMessageStats>
        implements ControlMessageStats {
    
        private final List<ControlMessage> _controlMessage;
        private final Long _rxUnknown;
        private final Long _txErrors;
    
        ControlMessageStatsImpl(ControlMessageStatsBuilder base) {
            super(base.augmentation);
            this._controlMessage = base.getControlMessage();
            this._rxUnknown = base.getRxUnknown();
            this._txErrors = base.getTxErrors();
        }
    
        @Override
        public List<ControlMessage> getControlMessage() {
            return _controlMessage;
        }
        
        @Override
        public Long getRxUnknown() {
            return _rxUnknown;
        }
        
        @Override
        public Long getTxErrors() {
            return _txErrors;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_controlMessage);
            result = prime * result + Objects.hashCode(_rxUnknown);
            result = prime * result + Objects.hashCode(_txErrors);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ControlMessageStats.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ControlMessageStats other = (ControlMessageStats)obj;
            if (!Objects.equals(_controlMessage, other.getControlMessage())) {
                return false;
            }
            if (!Objects.equals(_rxUnknown, other.getRxUnknown())) {
                return false;
            }
            if (!Objects.equals(_txErrors, other.getTxErrors())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ControlMessageStatsImpl otherImpl = (ControlMessageStatsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ControlMessageStats>>, Augmentation<ControlMessageStats>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ControlMessageStats");
            CodeHelpers.appendValue(helper, "_controlMessage", _controlMessage);
            CodeHelpers.appendValue(helper, "_rxUnknown", _rxUnknown);
            CodeHelpers.appendValue(helper, "_txErrors", _txErrors);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
