package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MapRegisterCacheStatsBuilder} instances.
 *
 * @see MapRegisterCacheStatsBuilder
 *
 */
public class MapRegisterCacheStatsBuilder implements Builder<MapRegisterCacheStats> {

    private Long _hits;
    private Long _misses;


    Map<Class<? extends Augmentation<MapRegisterCacheStats>>, Augmentation<MapRegisterCacheStats>> augmentation = Collections.emptyMap();

    public MapRegisterCacheStatsBuilder() {
    }
    public MapRegisterCacheStatsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats arg) {
        this._hits = arg.getHits();
        this._misses = arg.getMisses();
    }

    public MapRegisterCacheStatsBuilder(MapRegisterCacheStats base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<MapRegisterCacheStats>>, Augmentation<MapRegisterCacheStats>> aug =((AugmentationHolder<MapRegisterCacheStats>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._hits = base.getHits();
        this._misses = base.getMisses();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats) {
            this._hits = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats)arg).getHits();
            this._misses = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats)arg).getMisses();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CacheStats]");
    }

    public Long getHits() {
        return _hits;
    }
    
    public Long getMisses() {
        return _misses;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MapRegisterCacheStats>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public MapRegisterCacheStatsBuilder setHits(final Long value) {
        this._hits = value;
        return this;
    }
    
    public MapRegisterCacheStatsBuilder setMisses(final Long value) {
        this._misses = value;
        return this;
    }
    
    public MapRegisterCacheStatsBuilder addAugmentation(Class<? extends Augmentation<MapRegisterCacheStats>> augmentationType, Augmentation<MapRegisterCacheStats> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MapRegisterCacheStatsBuilder removeAugmentation(Class<? extends Augmentation<MapRegisterCacheStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MapRegisterCacheStats build() {
        return new MapRegisterCacheStatsImpl(this);
    }

    private static final class MapRegisterCacheStatsImpl
        extends AbstractAugmentable<MapRegisterCacheStats>
        implements MapRegisterCacheStats {
    
        private final Long _hits;
        private final Long _misses;
    
        MapRegisterCacheStatsImpl(MapRegisterCacheStatsBuilder base) {
            super(base.augmentation);
            this._hits = base.getHits();
            this._misses = base.getMisses();
        }
    
        @Override
        public Long getHits() {
            return _hits;
        }
        
        @Override
        public Long getMisses() {
            return _misses;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_hits);
            result = prime * result + Objects.hashCode(_misses);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MapRegisterCacheStats.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            MapRegisterCacheStats other = (MapRegisterCacheStats)obj;
            if (!Objects.equals(_hits, other.getHits())) {
                return false;
            }
            if (!Objects.equals(_misses, other.getMisses())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MapRegisterCacheStatsImpl otherImpl = (MapRegisterCacheStatsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<MapRegisterCacheStats>>, Augmentation<MapRegisterCacheStats>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MapRegisterCacheStats");
            CodeHelpers.appendValue(helper, "_hits", _hits);
            CodeHelpers.appendValue(helper, "_misses", _misses);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
