package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AddKeyOutputBuilder} instances.
 *
 * @see AddKeyOutputBuilder
 *
 */
public class AddKeyOutputBuilder implements Builder<AddKeyOutput> {



    Map<Class<? extends Augmentation<AddKeyOutput>>, Augmentation<AddKeyOutput>> augmentation = Collections.emptyMap();

    public AddKeyOutputBuilder() {
    }

    public AddKeyOutputBuilder(AddKeyOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AddKeyOutput>>, Augmentation<AddKeyOutput>> aug =((AugmentationHolder<AddKeyOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddKeyOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public AddKeyOutputBuilder addAugmentation(Class<? extends Augmentation<AddKeyOutput>> augmentationType, Augmentation<AddKeyOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public AddKeyOutputBuilder removeAugmentation(Class<? extends Augmentation<AddKeyOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AddKeyOutput build() {
        return new AddKeyOutputImpl(this);
    }

    private static final class AddKeyOutputImpl
        extends AbstractAugmentable<AddKeyOutput>
        implements AddKeyOutput {
    
    
        AddKeyOutputImpl(AddKeyOutputBuilder base) {
            super(base.augmentation);
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddKeyOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            AddKeyOutput other = (AddKeyOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AddKeyOutputImpl otherImpl = (AddKeyOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AddKeyOutput>>, Augmentation<AddKeyOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AddKeyOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
