package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.list.MappingRecordItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AddMappingsInputBuilder} instances.
 *
 * @see AddMappingsInputBuilder
 *
 */
public class AddMappingsInputBuilder implements Builder<AddMappingsInput> {

    private List<MappingRecordItem> _mappingRecordItem;


    Map<Class<? extends Augmentation<AddMappingsInput>>, Augmentation<AddMappingsInput>> augmentation = Collections.emptyMap();

    public AddMappingsInputBuilder() {
    }
    public AddMappingsInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList arg) {
        this._mappingRecordItem = arg.getMappingRecordItem();
    }

    public AddMappingsInputBuilder(AddMappingsInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AddMappingsInput>>, Augmentation<AddMappingsInput>> aug =((AugmentationHolder<AddMappingsInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mappingRecordItem = base.getMappingRecordItem();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList) {
            this._mappingRecordItem = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList)arg).getMappingRecordItem();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList]");
    }

    public List<MappingRecordItem> getMappingRecordItem() {
        return _mappingRecordItem;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddMappingsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public AddMappingsInputBuilder setMappingRecordItem(final List<MappingRecordItem> values) {
        this._mappingRecordItem = values;
        return this;
    }
    
    
    public AddMappingsInputBuilder addAugmentation(Class<? extends Augmentation<AddMappingsInput>> augmentationType, Augmentation<AddMappingsInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public AddMappingsInputBuilder removeAugmentation(Class<? extends Augmentation<AddMappingsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AddMappingsInput build() {
        return new AddMappingsInputImpl(this);
    }

    private static final class AddMappingsInputImpl
        extends AbstractAugmentable<AddMappingsInput>
        implements AddMappingsInput {
    
        private final List<MappingRecordItem> _mappingRecordItem;
    
        AddMappingsInputImpl(AddMappingsInputBuilder base) {
            super(base.augmentation);
            this._mappingRecordItem = base.getMappingRecordItem();
        }
    
        @Override
        public List<MappingRecordItem> getMappingRecordItem() {
            return _mappingRecordItem;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mappingRecordItem);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddMappingsInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            AddMappingsInput other = (AddMappingsInput)obj;
            if (!Objects.equals(_mappingRecordItem, other.getMappingRecordItem())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AddMappingsInputImpl otherImpl = (AddMappingsInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AddMappingsInput>>, Augmentation<AddMappingsInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AddMappingsInput");
            CodeHelpers.appendValue(helper, "_mappingRecordItem", _mappingRecordItem);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
