package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Describes the mappings belonging to the same Virtual Network Identifier
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * grouping db-instance {
 *   leaf vni {
 *     type vni-uri;
 *   }
 *   list mapping {
 *     key "eid-uri origin";
 *     ext:context-instance eid-context;
 *     leaf eid-uri {
 *       type eid-uri;
 *     }
 *     leaf origin {
 *       type mapping-origin;
 *     }
 *     leaf-list site-id {
 *       type lisp-proto:site-id;
 *     }
 *     uses lisp-proto:mapping-record-container;
 *     list xtr-id-mapping {
 *       config false;
 *       key xtr-id-uri;
 *       ext:context-instance xtrid-context;
 *       leaf xtr-id-uri {
 *         type xtr-id-uri;
 *       }
 *       uses lisp-proto:mapping-record-container;
 *     }
 *   }
 *   list authentication-key {
 *     key eid-uri;
 *     ext:context-instance eid-context;
 *     leaf eid-uri {
 *       type eid-uri;
 *     }
 *     uses lisp-proto:eid-container;
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/db-instance</i>
 *
 */
public interface DbInstance
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("db-instance");

    @Override
    Class<? extends DbInstance> implementedInterface();
    
    /**
     * The 24-bit Virtual Network Identifier
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri</code> <code>vni</code>, or <code>null</code> if not present
     */
    @Nullable VniUri getVni();
    
    /**
     * A list of EID-to-RLOC mappings within the same Instance ID
     *
     *
     *
     * @return <code>java.util.List</code> <code>mapping</code>, or <code>null</code> if not present
     */
    @Nullable List<Mapping> getMapping();
    
    /**
     * @return <code>java.util.List</code> <code>mapping</code>, or an empty list if it is not present
     */
    default @NonNull List<Mapping> nonnullMapping() {
        return CodeHelpers.nonnull(getMapping());
    }
    
    /**
     * A list of authentication keys for EID prefixes within the same Virtual Network 
     * Identifier
     *
     *
     *
     * @return <code>java.util.List</code> <code>authenticationKey</code>, or <code>null</code> if not present
     */
    @Nullable List<AuthenticationKey> getAuthenticationKey();
    
    /**
     * @return <code>java.util.List</code> <code>authenticationKey</code>, or an empty list if it is not present
     */
    default @NonNull List<AuthenticationKey> nonnullAuthenticationKey() {
        return CodeHelpers.nonnull(getAuthenticationKey());
    }

}

