package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * grouping eid-authkey-list {
 *   list eid-authkey-item {
 *     key eid-authkey-item-id;
 *     leaf eid-authkey-item-id {
 *       type string;
 *     }
 *     uses lisp-proto:eid-container;
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/eid-authkey-list</i>
 *
 */
public interface EidAuthkeyList
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("eid-authkey-list");

    @Override
    Class<? extends EidAuthkeyList> implementedInterface();
    
    /**
     * @return <code>java.util.List</code> <code>eidAuthkeyItem</code>, or <code>null</code> if not present
     */
    @Nullable List<EidAuthkeyItem> getEidAuthkeyItem();
    
    /**
     * @return <code>java.util.List</code> <code>eidAuthkeyItem</code>, or an empty list if it is not present
     */
    default @NonNull List<EidAuthkeyItem> nonnullEidAuthkeyItem() {
        return CodeHelpers.nonnull(getEidAuthkeyItem());
    }

}

